/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class TempFile
extends File
implements Closeable {
    private static final long serialVersionUID = 3421025956189900097L;

    public TempFile(String prefix, String suffix, File directory) throws IOException {
        super(TempFile.genPath(prefix, suffix, directory));
    }

    public TempFile(String prefix, String suffix) throws IOException {
        super(TempFile.genPath(prefix, suffix));
    }

    public TempFile(String prefix) throws IOException {
        super(TempFile.genPath(prefix, "tmp"));
    }

    private static String genPath(String prefix, String suffix) throws IOException {
        return TempFile.genPath(prefix, suffix, null);
    }

    private static String genPath(String prefix, String suffix, File dir) throws IOException {
        File tmp = File.createTempFile(prefix, suffix, dir);
        boolean permChange = tmp.setReadable(false, false);
        permChange = permChange && tmp.setWritable(false, false);
        permChange = permChange && tmp.setExecutable(false, false);
        permChange = permChange && tmp.setReadable(true, true);
        permChange = permChange && tmp.setWritable(true, true);
        return tmp.getPath();
    }

    @Override
    public void close() throws IOException {
        if (!this.delete()) {
            this.deleteOnExit();
        }
    }
}

