/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.file.builder;

import com.aeontronix.commons.file.builder.FileContent;
import com.aeontronix.commons.file.builder.FilesBuilder;
import com.aeontronix.commons.file.builder.FilesBuilderDir;
import com.aeontronix.commons.file.builder.FilesBuilderFile;
import com.aeontronix.commons.file.builder.FilesBuilderNode;
import com.aeontronix.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FilesBuilderNodeBuilder {
    protected FilesBuilder filesBuilder;
    protected FilesBuilderNode node;

    public FilesBuilderNodeBuilder(FilesBuilderNode node, FilesBuilder filesBuilder) {
        this.node = node;
        this.filesBuilder = filesBuilder;
    }

    Set<FilesBuilderFile> getFiles() {
        HashSet<FilesBuilderFile> nodes = new HashSet<FilesBuilderFile>();
        LinkedList<FilesBuilderDir> processingQueue = new LinkedList<FilesBuilderDir>();
        if (this.node instanceof FilesBuilderDir) {
            processingQueue.add((FilesBuilderDir)this.node);
            while (!processingQueue.isEmpty()) {
                FilesBuilderDir dir = (FilesBuilderDir)processingQueue.poll();
                for (FilesBuilderNode node : dir.getChildrens().values()) {
                    if (node instanceof FilesBuilderDir) {
                        processingQueue.add((FilesBuilderDir)node);
                        continue;
                    }
                    nodes.add((FilesBuilderFile)node);
                }
            }
        } else {
            nodes.add((FilesBuilderFile)this.node);
        }
        return nodes;
    }

    public InputStream buildZipFileAsStream() throws IOException {
        try (ByteArrayOutputStream buf = new ByteArrayOutputStream();){
            ByteArrayInputStream byteArrayInputStream;
            try (ZipOutputStream out = new ZipOutputStream(buf);){
                Set<FilesBuilderFile> nodes = this.filesBuilder.getFiles();
                for (FilesBuilderFile file : nodes) {
                    ZipEntry zipEntry = new ZipEntry(new ZipEntry(file.getPath("/")));
                    FileContent content = file.getContent();
                    zipEntry.setSize(content.getSize());
                    out.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)content.getDataStream(), (OutputStream)out);
                    out.closeEntry();
                }
                out.finish();
                out.flush();
                byteArrayInputStream = new ByteArrayInputStream(buf.toByteArray());
            }
            return byteArrayInputStream;
        }
    }

    public FilesBuilderNodeBuilder dir(String name) {
        FilesBuilderDir parentNode = this.getDirNode();
        FilesBuilderDir newDir = new FilesBuilderDir(name, parentNode);
        return new FilesBuilderNodeBuilder(newDir, this.filesBuilder);
    }

    public FilesBuilderNodeBuilder addZipContent(InputStream is) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                FilesBuilderNodeBuilder fb = this.deepFile(entry.getName(), "/");
                fb.content(zis);
                entry = zis.getNextEntry();
            }
        }
        return this;
    }

    public FilesBuilderNodeBuilder deepFile(String path, String separator) {
        LinkedList<String> els = new LinkedList<String>(Arrays.asList(path.split(separator)));
        String name = els.removeLast();
        FilesBuilderDir parentNode = this.getDirNode();
        for (String el : els) {
            parentNode = new FilesBuilderDir(el, parentNode);
        }
        FilesBuilderFile file = new FilesBuilderFile(name, parentNode);
        return new FilesBuilderNodeBuilder(file, this.filesBuilder);
    }

    public FilesBuilderNodeBuilder file(String name) {
        FilesBuilderDir parentNode = this.getDirNode();
        FilesBuilderFile fileNode = new FilesBuilderFile(name, parentNode);
        return new FilesBuilderNodeBuilder(fileNode, this.filesBuilder);
    }

    private void setContent(FileContent content) {
        if (!(this.node instanceof FilesBuilderFile)) {
            throw new IllegalStateException("Cannot add content to a directory");
        }
        ((FilesBuilderFile)this.node).setContent(content);
    }

    public FilesBuilderNodeBuilder content(byte[] data) throws IOException {
        this.setContent(this.filesBuilder.createContent(data));
        return this;
    }

    public FilesBuilderNodeBuilder content(InputStream data) throws IOException {
        this.setContent(this.filesBuilder.createContent(data));
        return this;
    }

    public FilesBuilderNodeBuilder content(String string) throws IOException {
        this.content(string, StandardCharsets.UTF_8);
        return this;
    }

    public FilesBuilderNodeBuilder content(String string, Charset encoding) throws IOException {
        this.setContent(this.filesBuilder.createContent(string.getBytes(encoding)));
        return this;
    }

    public FilesBuilderNodeBuilder file(String name, byte[] data) throws IOException {
        return this.file(name).content(data);
    }

    private FilesBuilderDir getDirNode() {
        FilesBuilderDir parentNode = this.node instanceof FilesBuilderFile ? this.node.getParent() : (FilesBuilderDir)this.node;
        return parentNode;
    }
}

