/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.file;

import com.aeontronix.commons.file.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class TempDir
extends File
implements Closeable {
    private static final long serialVersionUID = -3906256837550665841L;

    public TempDir(String prefix, String suffix, File directory) throws IOException {
        super(TempDir.create(prefix, suffix, directory));
    }

    public TempDir(String prefix, String suffix) throws IOException {
        super(TempDir.create(prefix, suffix));
    }

    public TempDir(String prefix) throws IOException {
        super(TempDir.create(prefix, ".tmp"));
    }

    private static String create(String prefix, String suffix) throws IOException {
        return TempDir.create(prefix, suffix, null);
    }

    private static String create(String prefix, String suffix, File directory) throws IOException {
        File tmp = null;
        try {
            tmp = File.createTempFile(prefix, suffix, directory);
            FileUtils.delete(tmp);
            if (!tmp.mkdir()) {
                throw new IOException("Unable to create temp dir: " + tmp.getPath());
            }
            boolean permChange = tmp.setReadable(false, false);
            permChange = permChange && tmp.setWritable(false, false);
            permChange = permChange && tmp.setExecutable(false, false);
            permChange = permChange && tmp.setReadable(true, true);
            permChange = permChange && tmp.setWritable(true, true);
            permChange = permChange && tmp.setExecutable(true, true);
            return tmp.getPath();
        }
        catch (IOException e) {
            try {
                FileUtils.delete(tmp);
            }
            catch (IOException ex) {
                throw new IOException("An error occured while creating temporary directory, and was unable to delete it afterwards", ex);
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                FileUtils.delete(tmp);
            }
            catch (IOException ex) {
                throw new IOException("An error occured while creating temporary directory, and was unable to delete it afterwards", ex);
            }
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            FileUtils.delete(true, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static TempDir createMavenTmpDir() throws IOException {
        return TempDir.createMavenTmpDir(null);
    }

    public static TempDir createMavenTmpDir(String altPath) throws IOException {
        File dir = new File("target");
        if (!dir.exists()) {
            if (altPath != null) {
                dir = new File(altPath.replace("/", File.separator) + File.separator + altPath);
            }
            if (altPath == null || !dir.exists()) {
                dir = new File(".");
            }
        }
        return new TempDir("_tmp", ".tmp", dir);
    }
}

