/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import com.aeontronix.commons.exception.DataLengthLimitException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BoundedOutputStream
extends FilterOutputStream {
    private final long maxLen;
    private final boolean failOnTooMuchData;
    private long count = 0L;
    private long mark;

    public BoundedOutputStream(OutputStream out, long maxLen, boolean failOnTooMuchData) {
        super(out);
        if (maxLen <= 0L) {
            throw new IllegalArgumentException("maxLen smaller than 1");
        }
        this.maxLen = maxLen;
        this.failOnTooMuchData = failOnTooMuchData;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.checkWithinLimits(1)) {
            super.write(b);
            ++this.count;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.checkWithinLimits(b.length)) {
            super.write(b);
            this.count += (long)b.length;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.checkWithinLimits(len)) {
            super.write(b, off, len);
            this.count += (long)len;
        }
    }

    private boolean checkWithinLimits(int size) throws DataLengthLimitException {
        if (this.count + (long)size > this.maxLen) {
            if (this.failOnTooMuchData) {
                throw new DataLengthLimitException();
            }
            return false;
        }
        return true;
    }
}

