/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DataInputStream
extends java.io.DataInputStream {
    public static final int DEFAULT_MAX_LEN = 10240;

    public DataInputStream(InputStream in) {
        super(in);
    }

    @Deprecated
    public String readString() throws IOException {
        return DataInputStream.readNullableUTF(this);
    }

    public UUID readUUID() throws IOException {
        return DataInputStream.readUUID(this);
    }

    public long readUnsignedNumber() throws IOException {
        int i;
        long number = 0L;
        int shift = 0;
        while ((i = this.read()) != -1) {
            boolean more = ((long)i & 0x80L) > 0L;
            number |= ((long)i & 0x7FL) << shift;
            shift += 7;
            if (more) continue;
        }
        return number;
    }

    public byte[] readFully(int dataLen) throws IOException {
        return DataInputStream.readFully(this, dataLen);
    }

    public byte[] readData() throws IOException {
        return this.readData(false, 10240);
    }

    public byte[] readData(boolean nonNull) throws IOException {
        return this.readData(nonNull, 10240);
    }

    public byte[] readRemainingData() throws IOException {
        return DataInputStream.readRemainingData(this);
    }

    public byte[] readData(boolean nonNull, int maxLen) throws IOException {
        byte[] bytes = DataInputStream.readData(this, maxLen);
        if (bytes == null && nonNull) {
            throw new IOException("readData return null when expected not to");
        }
        return bytes;
    }

    public List<Long> readLongList() throws IOException {
        return DataInputStream.readLongList(this);
    }

    public List<UUID> readUUIDList() throws IOException {
        return DataInputStream.readUUIDList(this);
    }

    public List<Integer> readIntList() throws IOException {
        return DataInputStream.readIntList(this);
    }

    public List<String> readUTFList() throws IOException {
        return DataInputStream.readUTFList(this);
    }

    public <X> X readByteEnum(Class<X> enumClass) throws IOException {
        return DataInputStream.readEnum(enumClass, this.readByte());
    }

    public <X> X readShortEnum(Class<X> enumClass) throws IOException {
        return DataInputStream.readEnum(enumClass, this.readShort());
    }

    public <X> X readIntEnum(Class<X> enumClass) throws IOException {
        return DataInputStream.readEnum(enumClass, this.readInt());
    }

    public <X> X readEnum(Class<X> enumClass) throws IOException {
        return DataInputStream.readEnum(enumClass, (int)this.readUnsignedNumber());
    }

    public Boolean readNullableBoolean() throws IOException {
        if (this.readBoolean()) {
            return this.readBoolean();
        }
        return null;
    }

    public Byte readNullableByte() throws IOException {
        if (this.readBoolean()) {
            return this.readByte();
        }
        return null;
    }

    public Short readNullableShort() throws IOException {
        if (this.readBoolean()) {
            return this.readShort();
        }
        return null;
    }

    public Integer readNullableInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public Long readNullableLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public Float readNullableFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    public Double readNullableDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public String readNullableUTF() throws IOException {
        return DataInputStream.readNullableUTF(this);
    }

    public static String readNullableUTF(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    @Deprecated
    public static String readString(DataInput in) throws IOException {
        return DataInputStream.readNullableUTF(in);
    }

    public static UUID readUUID(DataInput in) throws IOException {
        long mostSigBits = in.readLong();
        long leastSigBits = in.readLong();
        if (mostSigBits != 0L && leastSigBits != 0L) {
            return new UUID(mostSigBits, leastSigBits);
        }
        return null;
    }

    public static byte[] readFully(DataInput in, int dataLen) throws IOException {
        byte[] data = new byte[dataLen];
        in.readFully(data);
        return data;
    }

    public static byte[] readData(DataInput in) throws IOException {
        return DataInputStream.readData(in, 10240);
    }

    public static byte[] readData(DataInput in, int maxLen) throws IOException {
        int len = in.readInt();
        if (len > maxLen) {
            throw new IOException("Data block larger than max " + maxLen + ": " + len);
        }
        if (len > 0) {
            byte[] data = new byte[len];
            in.readFully(data);
            return data;
        }
        if (len == 0) {
            return new byte[0];
        }
        return null;
    }

    public static byte[] readRemainingData(java.io.DataInputStream in) throws IOException {
        return DataInputStream.readRemainingData(in, 10240);
    }

    public static byte[] readRemainingData(java.io.DataInputStream in, int maxLen) throws IOException {
        int v;
        int available = in.available();
        if (available > maxLen) {
            throw new IOException("Data block larger than max " + maxLen + ": " + available);
        }
        byte[] block = null;
        if (available > 0) {
            block = DataInputStream.readFully(in, available);
        }
        if ((v = in.read()) == -1) {
            return block != null ? block : new byte[]{};
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (block != null) {
            buf.write(block);
        }
        buf.write(v);
        while (v != -1) {
            available = in.available();
            if (available > 0) {
                if (buf.size() + available > maxLen) {
                    throw new IOException("Data block larger than max " + maxLen + ": " + buf.size() + available);
                }
                buf.write(DataInputStream.readFully(in, available));
            }
            v = in.read();
            if (buf.size() + 1 > maxLen) {
                throw new IOException("Data block larger than max " + maxLen + ": " + buf.size() + 1);
            }
            if (v == -1) continue;
            buf.write(v);
        }
        return buf.toByteArray();
    }

    public static List<Long> readLongList(DataInput in) throws IOException {
        int nb = in.readInt();
        ArrayList<Long> list = new ArrayList<Long>(nb);
        for (int i = 0; i < nb; ++i) {
            list.add(in.readLong());
        }
        return list;
    }

    public static List<UUID> readUUIDList(DataInput in) throws IOException {
        int nb = in.readInt();
        ArrayList<UUID> list = new ArrayList<UUID>(nb);
        for (int i = 0; i < nb; ++i) {
            list.add(DataInputStream.readUUID(in));
        }
        return list;
    }

    public static List<Integer> readIntList(DataInput in) throws IOException {
        int nb = in.readInt();
        ArrayList<Integer> list = new ArrayList<Integer>(nb);
        for (int i = 0; i < nb; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    public static List<String> readUTFList(DataInput in) throws IOException {
        int nb = in.readInt();
        ArrayList<String> list = new ArrayList<String>(nb);
        for (int i = 0; i < nb; ++i) {
            list.add(in.readUTF());
        }
        return list;
    }

    private static <X> X readEnum(Class<X> enumClass, int idx) throws IOException {
        try {
            return idx == 0 ? null : (X)enumClass.getEnumConstants()[idx - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Invalid enum value");
        }
    }
}

