/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecordingInputStream
extends FilterInputStream {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private boolean recording;

    public RecordingInputStream(InputStream inputStream) {
        this(inputStream, true);
    }

    public RecordingInputStream(InputStream inputStream, boolean recording) {
        super(inputStream);
        this.recording = recording;
    }

    @Override
    public int read() throws IOException {
        int i = super.read();
        if (this.recording && i != -1) {
            this.data.write(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = super.read(b);
        if (this.recording && i != -1) {
            this.data.write(b, 0, i);
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = super.read(b, off, len);
        if (this.recording && i != -1) {
            this.data.write(b, off, i);
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.data.close();
    }

    public byte[] getData() {
        return this.data.toByteArray();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }
}

