/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.io.DataInputStream;
import com.aeontronix.commons.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class BatchQueue<X> {
    private final int overflowStart;
    private final int overflowEnd;
    private final int maxFileSize;
    private int batchSize;
    private final LinkedList<X> queue;
    private final File overflowDir;
    private boolean overflowing;
    private final LinkedList<OverflowFile> openOverflowFiles = new LinkedList();
    private final LinkedList<OverflowFile> closedOverflowFiles = new LinkedList();

    public BatchQueue(int overflowStart, int overflowEnd, int maxFileSize, int batchSize, File overflowDir) {
        this.overflowStart = overflowStart;
        this.overflowEnd = overflowEnd;
        this.batchSize = batchSize;
        this.queue = new LinkedList();
        this.maxFileSize = maxFileSize;
        this.overflowDir = overflowDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(X x) throws IOException {
        OverflowFile overflowFile = null;
        BatchQueue batchQueue = this;
        synchronized (batchQueue) {
            if (this.overflowing) {
                Optional<OverflowFile> ovf = this.openOverflowFiles.stream().filter(f -> !((OverflowFile)f).locked).findFirst();
                if (ovf.isPresent()) {
                    overflowFile = ovf.get();
                    this.openOverflowFiles.remove(overflowFile);
                } else {
                    try {
                        overflowFile = new OverflowFile();
                        this.openOverflowFiles.add(overflowFile);
                    }
                    catch (FileNotFoundException e) {
                        throw new IOException(e);
                    }
                }
            } else {
                this.queue.add(x);
                if (this.queue.size() >= this.overflowStart) {
                    this.overflowing = true;
                }
            }
        }
        if (overflowFile != null) {
            byte[] data = this.serialize(x);
            overflowFile.write(data);
            if (overflowFile.file.length() > (long)this.maxFileSize) {
                overflowFile.stream.close();
                this.openOverflowFiles.remove(overflowFile);
                this.closedOverflowFiles.add(overflowFile);
            }
            BatchQueue batchQueue2 = this;
            synchronized (batchQueue2) {
                overflowFile.locked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Processor<X> proc) {
        ArrayList<X> data = new ArrayList<X>(this.batchSize);
        BatchQueue batchQueue = this;
        synchronized (batchQueue) {
            for (int i = 0; i < this.batchSize && !this.queue.isEmpty(); ++i) {
                data.add(this.queue.removeLast());
            }
            if (this.queue.size() < this.overflowEnd) {
                this.overflowing = false;
            }
        }
        if (!data.isEmpty()) {
            try {
                proc.process(data);
            }
            catch (Exception e) {
                BatchQueue batchQueue2 = this;
                synchronized (batchQueue2) {
                    this.queue.addAll(data);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOverflow(Processor<X> func) throws IOException {
        BatchQueue batchQueue = this;
        synchronized (batchQueue) {
            if (!this.closedOverflowFiles.isEmpty()) {
                try {
                    OverflowFile ovfile = this.closedOverflowFiles.getFirst();
                    List data = ovfile.read();
                    func.process(data);
                    if (!ovfile.file.delete()) {
                        ovfile.file.deleteOnExit();
                    }
                    this.openOverflowFiles.remove(ovfile);
                    this.closedOverflowFiles.remove(ovfile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected byte[] serialize(X x) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(buffer);
        os.writeObject(x);
        os.flush();
        return buffer.toByteArray();
    }

    protected List<X> deserialize(InputStream is) throws IOException {
        ArrayList<Object> data = new ArrayList<Object>();
        try {
            ObjectInputStream os = new ObjectInputStream(is);
            try {
                while (true) {
                    data.add(os.readObject());
                }
            }
            catch (Throwable throwable) {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException os) {
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException((Throwable)e);
        }
        return data;
    }

    private class OverflowFile
    implements Closeable {
        private final File file;
        private final DataOutputStream stream;
        private boolean locked;

        public OverflowFile() throws IOException {
            this.file = new File(BatchQueue.this.overflowDir, UUID.randomUUID().toString());
            this.stream = new DataOutputStream(Files.newOutputStream(this.file.toPath(), new OpenOption[0]));
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        public void write(byte[] data) throws IOException {
            this.stream.write(data);
        }

        public List<X> read() throws IOException {
            try (DataInputStream is = new DataInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));){
                List list = BatchQueue.this.deserialize(is);
                return list;
            }
        }
    }

    public static interface Processor<X> {
        public void process(List<X> var1) throws Exception;
    }
}

