/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import com.aeontronix.commons.exception.DataLengthLimitException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private final long maxLen;
    private final boolean failOnTooMuchData;
    private long count = 0L;
    private long mark;

    public BoundedInputStream(InputStream in, long maxLen, boolean failOnTooMuchData) {
        super(in);
        if (maxLen <= 0L) {
            throw new IllegalArgumentException("maxLen smaller than 1");
        }
        this.maxLen = maxLen;
        this.failOnTooMuchData = failOnTooMuchData;
    }

    @Override
    public int read() throws IOException {
        if (!this.failOnTooMuchData && this.count >= this.maxLen) {
            return -1;
        }
        int res = super.read();
        if (res != -1) {
            ++this.count;
            if (this.failOnTooMuchData && this.count > this.maxLen) {
                throw new DataLengthLimitException();
            }
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.failOnTooMuchData && this.count >= this.maxLen) {
            return -1;
        }
        int dataRead = super.read(b, off, this.failOnTooMuchData ? len : (int)Math.min((long)len, this.maxLen - this.count));
        if (dataRead > 0 && this.count + (long)dataRead > this.maxLen && this.failOnTooMuchData) {
            throw new DataLengthLimitException();
        }
        return dataRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.failOnTooMuchData && this.count >= this.maxLen) {
            return -1L;
        }
        long skip = super.skip(this.failOnTooMuchData ? n : (long)((int)Math.min(n, this.maxLen - this.count)));
        if (skip > 0L && this.count + skip > this.maxLen && this.failOnTooMuchData) {
            throw new DataLengthLimitException();
        }
        return skip;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.count = this.mark;
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }
}

