/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CountingInputStream
extends FilterInputStream {
    private int count;

    public CountingInputStream(@NotNull InputStream wrapped) {
        super(wrapped);
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val != -1) {
            ++this.count;
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inc(super.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inc(super.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (skipped > 0L) {
            this.count = (int)((long)this.count + skipped);
        }
        return skipped;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }

    private int inc(int bytesRead) {
        if (bytesRead > 0) {
            this.count += bytesRead;
        }
        return bytesRead;
    }
}

