/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class DataOutputStream
extends java.io.DataOutputStream {
    public static final long MAX = Long.MAX_VALUE;
    public static final long[] BOUNDS = new long[]{127L, 16383L, 0x1FFFFFL, 0xFFFFFFFL, 0x7FFFFFFFFL, 0x3FFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    @Deprecated
    public void writeString(String str) throws IOException {
        DataOutputStream.writeNullableUTF(this, str);
    }

    public void writeUnsignedNumber(long number) throws IOException {
        if (number < 0L) {
            throw new IllegalArgumentException("Number isn't unsigned");
        }
        int shift = 0;
        for (long bound : BOUNDS) {
            boolean more = number > bound;
            this.write((int)((number & bound) >> shift) | (more ? 128 : 0));
            if (!more) break;
            shift += 7;
        }
    }

    public void writeData(byte[] data) throws IOException {
        DataOutputStream.writeData(this, data);
    }

    public void writeUUID(UUID uuid) throws IOException {
        DataOutputStream.writeUUID(this, uuid);
    }

    public void writeByteEnum(Enum<?> enumeration) throws IOException {
        this.writeByte(DataOutputStream.enumValue(enumeration));
    }

    public void writeShortEnum(Enum<?> enumeration) throws IOException {
        this.writeShort(DataOutputStream.enumValue(enumeration));
    }

    public void writeIntEnum(Enum<?> enumeration) throws IOException {
        this.writeInt(DataOutputStream.enumValue(enumeration));
    }

    public void writeEnum(@Nullable Enum<?> enumeration) throws IOException {
        this.writeUnsignedNumber(DataOutputStream.enumValue(enumeration));
    }

    public void writeLongList(List<Long> list) throws IOException {
        this.writeInt(list.size());
        for (Long val : list) {
            this.writeLong(val);
        }
    }

    public void writeIntList(List<Integer> list) throws IOException {
        this.writeInt(list.size());
        for (Integer val : list) {
            this.writeInt(val);
        }
    }

    public void writeUUIDList(List<UUID> list) throws IOException {
        this.writeInt(list.size());
        for (UUID val : list) {
            this.writeUUID(val);
        }
    }

    public void writeUTFList(List<String> list) throws IOException {
        this.writeInt(list.size());
        for (String val : list) {
            this.writeUTF(val);
        }
    }

    public void writeNullableBoolean(Boolean value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeBoolean(value);
        }
    }

    public void writeNullableByte(Byte value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeByte(value.byteValue());
        }
    }

    public void writeNullableShort(Short value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeShort(value.shortValue());
        }
    }

    public void writeNullableInt(Integer value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeInt(value);
        }
    }

    public void writeNullableLong(Long value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeLong(value);
        }
    }

    public void writeNullableFloat(Float value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeFloat(value.floatValue());
        }
    }

    public void writeNullableDouble(Float value) throws IOException {
        boolean isNotNull = value != null;
        this.writeBoolean(isNotNull);
        if (isNotNull) {
            this.writeDouble(value.floatValue());
        }
    }

    public void writeNullableUTF(String str) throws IOException {
        DataOutputStream.writeNullableUTF(this, str);
    }

    public static void writeNullableUTF(DataOutput out, String str) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }

    @Deprecated
    public static void writeString(DataOutput out, String str) throws IOException {
        DataOutputStream.writeNullableUTF(out, str);
    }

    public static void writeData(DataOutput out, byte[] data) throws IOException {
        int len = data != null ? data.length : -1;
        out.writeInt(len);
        if (len > -1) {
            out.write(data);
        }
    }

    public static void writeUUID(DataOutput out, UUID uuid) throws IOException {
        if (uuid != null) {
            out.writeLong(uuid.getMostSignificantBits());
            out.writeLong(uuid.getLeastSignificantBits());
        } else {
            out.writeLong(0L);
            out.writeLong(0L);
        }
    }

    protected static int enumValue(Enum<?> enumeration) {
        return enumeration != null ? enumeration.ordinal() + 1 : 0;
    }
}

