/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import com.aeontronix.commons.io.ByteArrayDataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    private static final int DEF_BUFF_SIZE = 10240;
    private static final int DEF_CHAR_BUFF_SIZE = 200;

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayDataOutputStream buffer = new ByteArrayDataOutputStream();
        IOUtils.copy(inputStream, buffer);
        buffer.close();
        return buffer.toByteArray();
    }

    public static byte[] toByteArray(DataGenerator dataGenerator) throws IOException {
        ByteArrayDataOutputStream buffer = new ByteArrayDataOutputStream();
        dataGenerator.generateData(buffer);
        IOUtils.close(buffer);
        return buffer.toByteArray();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 10240);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, DataCopyListener listener) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 10240, listener);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufSize) throws IOException {
        return IOUtils.copy(inputStream, outputStream, bufSize, null);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufSize, DataCopyListener listener) throws IOException {
        int read;
        byte[] buffer = new byte[bufSize];
        long count = 0L;
        while ((read = inputStream.read(buffer)) > 0) {
            if (listener != null) {
                listener.dataCopied(buffer, read);
            }
            outputStream.write(buffer, 0, read);
            count += (long)read;
        }
        return count;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IOUtils.copy(reader, writer, 200, null);
    }

    private static long copy(Reader reader, Writer writer, int bufSize) throws IOException {
        return IOUtils.copy(reader, writer, bufSize);
    }

    private static long copy(Reader reader, Writer writer, int bufSize, DataCopyListener listener) throws IOException {
        int read;
        char[] buffer = new char[bufSize];
        long count = 0L;
        while ((read = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, read);
            count += (long)read;
        }
        return count;
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString(inputStream, "UTF-8");
    }

    public static String toString(InputStream inputStream, String encoding) throws IOException {
        return IOUtils.toString(new InputStreamReader(inputStream, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter buffer = new StringWriter();
        IOUtils.copy(reader, buffer);
        return buffer.toString();
    }

    public static void close(Object ... objects) {
        for (Object object : objects) {
            if (!(object instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)object).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static interface DataGenerator {
        public void generateData(OutputStream var1) throws IOException;
    }

    public static interface DataCopyListener {
        public void dataCopied(byte[] var1, int var2) throws IOException;
    }
}

