/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.io;

import com.aeontronix.commons.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public abstract class InMemInputFilterStream
extends FilterInputStream {
    private ByteArrayInputStream buf;

    public InMemInputFilterStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        return this.getDataStream().read();
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.getDataStream().read(b);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.getDataStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getDataStream().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.getDataStream().available();
    }

    @Override
    public void close() throws IOException {
        this.getDataStream().close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.getDataStream().mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getDataStream().reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    protected ByteArrayInputStream getDataStream() throws IOException {
        if (this.buf == null) {
            byte[] data = this.load();
            this.buf = new ByteArrayInputStream(this.transform(data));
        }
        return this.buf;
    }

    protected byte[] load() throws IOException {
        return IOUtils.toByteArray(this.in);
    }

    protected abstract byte[] transform(byte[] var1) throws IOException;
}

