/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.properties;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class PropertiesUtils {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
    private static final JavaPropsMapper propsMapper = new JavaPropsMapper();

    public static Map<String, String> toMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public static Properties readProperties(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            Properties properties = PropertiesUtils.readProperties((InputStream)fis, PropertiesUtils.getFileExtension(file));
            return properties;
        }
    }

    public static void writeProperties(File file, Properties properties) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            PropertiesUtils.writeProperties((OutputStream)fos, properties, PropertiesUtils.getFileExtension(file));
        }
    }

    private static void writeProperties(OutputStream outputStream, Properties properties, String ext) throws IOException {
        if ((ext = ext.toLowerCase(Locale.ROOT)).equals("properties")) {
            properties.store(outputStream, null);
        } else if (ext.equals("json")) {
            PropertiesUtils.writeProperties(outputStream, properties, jsonMapper);
        } else if (ext.equals("yaml")) {
            PropertiesUtils.writeProperties(outputStream, properties, yamlMapper);
        } else {
            throw new IllegalArgumentException("Invalid extension: " + ext);
        }
    }

    private static void writeProperties(OutputStream outputStream, Properties properties, ObjectMapper mapper) throws IOException {
        Map map = (Map)propsMapper.readPropertiesAs(properties, Map.class);
        mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)map);
    }

    private static String getFileExtension(File file) {
        String fn = file.getName();
        int i = fn.lastIndexOf(46);
        if (i == -1) {
            throw new IllegalArgumentException("No extension found: " + fn);
        }
        return fn.substring(i + 1);
    }

    private static Properties readProperties(InputStream is, String ext) throws IOException {
        if ((ext = ext.toLowerCase(Locale.ROOT)).equals("properties")) {
            Properties props = new Properties();
            props.load(is);
            return props;
        }
        if (ext.equals("json")) {
            return PropertiesUtils.readProperties(is, jsonMapper);
        }
        if (ext.equals("yaml") || ext.equals(".yml")) {
            return PropertiesUtils.readProperties(is, yamlMapper);
        }
        throw new IllegalArgumentException("Invalid extension: " + ext);
    }

    private static Properties readProperties(InputStream is, ObjectMapper om) throws IOException {
        JsonNode jsonNode = om.readTree(is);
        return propsMapper.writeValueAsProperties((Object)jsonNode);
    }
}

