/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class PlaceholderTextField
extends JTextField {
    private String placeholder;

    public PlaceholderTextField() {
    }

    public PlaceholderTextField(Document pDoc, String pText, int pColumns) {
        super(pDoc, pText, pColumns);
    }

    public PlaceholderTextField(int pColumns) {
        super(pColumns);
    }

    public PlaceholderTextField(String pText) {
        super(pText);
    }

    public PlaceholderTextField(String pText, int pColumns) {
        super(pText, pColumns);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getDisabledTextColor());
        g.drawString(this.placeholder, this.getInsets().left, pG.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    public void setPlaceholder(String s) {
        this.placeholder = s;
    }
}

