/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.swing;

import com.aeontronix.commons.validation.ValidationUtils;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SwingUtils {
    private static Logger logger = Logger.getAnonymousLogger();

    public static JFrame createFrame(String title, JPanel panel, Preferences prefs, int defWidth, int defHeight) {
        ValidationUtils.validateWithinBounds((String)"defWidth/defHeight cannot be smaller than 0 or greater than 100", (long)0L, (long)100L, (long[])new long[]{defHeight, defWidth});
        Frame frame = new Frame(title, prefs);
        SwingUtils.centerFrame(frame, prefs, defWidth, defHeight);
        frame.add(panel);
        return frame;
    }

    public static void centerFrame(JFrame frame, Preferences prefs, int defWidth, int defHeight) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = (int)(screenSize.getWidth() / 100.0 * (double)defWidth);
        int h = (int)(screenSize.getHeight() / 100.0 * (double)defHeight);
        int x = (int)((screenSize.getWidth() - (double)w) / 2.0);
        int y = (int)((screenSize.getHeight() - (double)h) / 2.0);
        if (prefs != null) {
            frame.setBounds(prefs.getInt("x", x), prefs.getInt("y", y), prefs.getInt("w", w), prefs.getInt("h", h));
        } else {
            frame.setBounds(x, y, w, h);
        }
    }

    public static class Frame
    extends JFrame {
        private static final long serialVersionUID = -5345962084881252916L;

        public Frame(String title, final Preferences prefs) throws HeadlessException {
            super(title);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    prefs.putInt("x", this.getX());
                    prefs.putInt("y", this.getY());
                    prefs.putInt("h", this.getHeight());
                    prefs.putInt("w", this.getWidth());
                    try {
                        prefs.sync();
                    }
                    catch (BackingStoreException ex) {
                        logger.log(Level.WARNING, "Unable to save window preferences", ex);
                    }
                }
            });
        }
    }
}

