/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.validation;

import com.aeontronix.commons.exception.ExceptionUtils;
import com.aeontronix.commons.validation.AnnotationBasedValidator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AnnotationBasedValidatorJSR303Impl
implements AnnotationBasedValidator {
    private final Validator validator;
    private final Exception validatorFailException;

    public AnnotationBasedValidatorJSR303Impl() {
        Validator validatorImpl = null;
        Exception fail = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validatorImpl = factory.getValidator();
        }
        catch (Exception e) {
            fail = e;
        }
        this.validator = validatorImpl;
        this.validatorFailException = fail;
    }

    @Override
    public <E extends Exception> void validate(Object object, Class<E> exceptionClass, Class<?> ... validationGroups) throws E {
        if (this.validator == null) {
            throw new RuntimeException("No validator available: " + this.validatorFailException.getMessage(), this.validatorFailException);
        }
        Set violations = this.validator.validate(object, (Class[])validationGroups);
        if (!violations.isEmpty()) {
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            String errorMsg = violation.getPropertyPath().toString() + ": " + violation.getMessage();
            ExceptionUtils.throwException(exceptionClass, (String)errorMsg);
        }
    }
}

