/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.validation;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.SystemUtils;
import com.aeontronix.commons.exception.ExceptionUtils;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.validation.AnnotationBasedValidator;
import com.aeontronix.commons.validation.AnnotationBasedValidatorJSR303Impl;

public class ValidationUtils {
    private static final AnnotationBasedValidator annotationBasedValidator = SystemUtils.hasClass((String)"javax.validation.Validator") ? new AnnotationBasedValidatorJSR303Impl() : null;

    public static <E extends Exception> void validate(Object object, Class<E> exceptionClass, Class<?> ... validationGroups) throws E {
        if (annotationBasedValidator == null) {
            throw new UnexpectedException("No annotation based validator available");
        }
        annotationBasedValidator.validate(object, exceptionClass, validationGroups);
    }

    public static void validateWithinBounds(String msg, long min, long max, long ... values) throws IllegalArgumentException {
        ValidationUtils.validateWithinBounds(IllegalArgumentException.class, msg, min, max, values);
    }

    public static <E extends Exception> void validateWithinBounds(Class<E> exceptionClass, String msg, long min, long max, long ... values) throws E {
        for (long value : values) {
            if (value >= min && value <= max) continue;
            ExceptionUtils.throwException(exceptionClass, (String)msg);
        }
    }

    public static <E extends Exception> void notNull(Class<E> exceptionClass, String msg, Object ... values) throws E {
        if (values != null) {
            for (Object value : values) {
                if (value != null) continue;
                ExceptionUtils.throwException(exceptionClass, (String)msg);
            }
        }
    }

    public static <E extends Exception> void notEmpty(Class<E> exceptionClass, String msg, String ... values) throws E {
        if (values != null) {
            for (String value : values) {
                if (!StringUtils.isEmpty((String)value)) continue;
                ExceptionUtils.throwException(exceptionClass, (String)msg);
            }
        }
    }

    public static boolean notEmpty(String ... values) {
        for (String value : values) {
            if (!StringUtils.isEmpty((String)value)) continue;
            return false;
        }
        return true;
    }
}

