/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.xml;

import com.aeontronix.commons.exception.UnexpectedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSResourceResolver;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final WeakHashMap<Thread, SoftReference<DocumentBuilderFactory>> documentBuilderFactoryCache = new WeakHashMap();
    private static final WeakHashMap<Thread, SoftReference<DocumentBuilder>> documentBuilderCache = new WeakHashMap();
    private static final WeakHashMap<Thread, SoftReference<DOMImplementationRegistry>> domImplReg = new WeakHashMap();
    public static final boolean DF_NSAWARE = true;

    public static Document createDocument() {
        return XmlUtils.createDocument(true);
    }

    public static Document createDocument(boolean namespaceAware) {
        return XmlUtils.getDocumentBuilder(namespaceAware).newDocument();
    }

    private static Schema createSchema(LSResourceResolver rsResolver, InputStream schema) throws SAXException {
        return XmlUtils.createSchema(rsResolver, new StreamSource(schema));
    }

    private static Schema createSchema(InputStream schema) throws SAXException {
        return XmlUtils.createSchema(new StreamSource(schema));
    }

    private static Schema createSchema(LSResourceResolver rsResolver, Reader schema) throws SAXException {
        return XmlUtils.createSchema(rsResolver, new StreamSource(schema));
    }

    public static Schema createSchema(Reader schema) throws SAXException {
        return XmlUtils.createSchema(new StreamSource(schema));
    }

    public static Schema createSchema(Source ... sources) throws SAXException {
        return XmlUtils.createSchema(null, sources);
    }

    public static Schema createSchema(LSResourceResolver rsResolver, Source ... sources) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (rsResolver != null) {
            sf.setResourceResolver(rsResolver);
        }
        if (sources.length == 0) {
            throw new IllegalArgumentException("At least one source must be provided");
        }
        if (sources.length > 1) {
            return sf.newSchema(sources);
        }
        return sf.newSchema(sources[0]);
    }

    public static Document parse(File file) throws IOException, SAXException {
        return XmlUtils.parse(file, true);
    }

    public static Document parse(File file, boolean namespaceAware) throws IOException, SAXException {
        return XmlUtils.getDocumentBuilder(namespaceAware).parse(file);
    }

    public static Document parse(InputStream stream) throws IOException, SAXException {
        return XmlUtils.parse(stream, true);
    }

    public static Document parse(InputStream stream, boolean namespaceAware) throws IOException, SAXException {
        return XmlUtils.getDocumentBuilder(namespaceAware).parse(new InputSource(stream));
    }

    public static Document parse(Reader reader) throws IOException, SAXException {
        return XmlUtils.parse(reader, true);
    }

    public static Document parse(Reader reader, boolean namespaceAware) throws IOException, SAXException {
        return XmlUtils.getDocumentBuilder(namespaceAware).parse(new InputSource(reader));
    }

    public static Document parse(byte[] data) throws IOException, SAXException {
        return XmlUtils.parse(data, true);
    }

    public static Document parse(byte[] data, boolean namespaceAware) throws IOException, SAXException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Document document = XmlUtils.getDocumentBuilder(namespaceAware).parse(is);
            return document;
        }
    }

    public static Document parse(String uri) throws IOException, SAXException {
        return XmlUtils.parse(uri, true);
    }

    public static Document parse(String uri, boolean namespaceAware) throws IOException, SAXException {
        return XmlUtils.getDocumentBuilder(namespaceAware).parse(uri);
    }

    public static Document parse(URI uri) throws IOException, SAXException {
        return XmlUtils.parse(uri, true);
    }

    public static Document parse(URI uri, boolean namespaceAware) throws IOException, SAXException {
        return XmlUtils.getDocumentBuilder().parse(uri.toString());
    }

    public static Node getChild(Node parent, String nodename) {
        for (Node child : XmlUtils.toList(parent.getChildNodes())) {
            if (!child.getNodeName().equalsIgnoreCase(nodename)) continue;
            return child;
        }
        return null;
    }

    public static Element getChildElement(Node parent, String elementname, boolean create) throws DOMException {
        Node child = XmlUtils.getChild(parent, elementname);
        if (child instanceof Element) {
            return (Element)child;
        }
        if (child == null) {
            if (create) {
                child = parent.getOwnerDocument().createElement(elementname);
                parent.appendChild(child);
                return (Element)child;
            }
            return null;
        }
        throw new DOMException(17, "There are exists an non-element node (" + child.getClass().getName() + ") named " + elementname);
    }

    public static void serialize(Node node, Writer writer) {
        XmlUtils.doSerialize(node, writer, node instanceof Document, true);
    }

    public static void serialize(Node node, OutputStream stream) {
        XmlUtils.doSerialize(node, stream, node instanceof Document, true);
    }

    public static void serialize(Node node, Writer writer, boolean xmlDeclaration, boolean prettyPrint) {
        XmlUtils.doSerialize(node, writer, xmlDeclaration, prettyPrint);
    }

    public static void serialize(Node node, OutputStream writer, boolean xmlDeclaration, boolean prettyPrint) {
        XmlUtils.doSerialize(node, writer, xmlDeclaration, prettyPrint);
    }

    public static String toString(Node node) {
        return XmlUtils.toString(node, node instanceof Document, true);
    }

    public static String toString(Node node, boolean xmlDeclaration, boolean prettyPrint) {
        StringWriter xml = new StringWriter();
        XmlUtils.doSerialize(node, xml, xmlDeclaration, prettyPrint);
        return xml.toString();
    }

    private static void doSerialize(Node node, Object writer, boolean xmlDeclaration, boolean prettyPrint) {
        DOMImplementationRegistry registry = XmlUtils.getDomImplRegistry();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        DOMConfiguration cfg = serializer.getDomConfig();
        cfg.setParameter("xml-declaration", xmlDeclaration);
        cfg.setParameter("format-pretty-print", prettyPrint);
        LSOutput output = impl.createLSOutput();
        if (writer instanceof Writer) {
            output.setCharacterStream((Writer)writer);
        } else if (writer instanceof OutputStream) {
            output.setByteStream((OutputStream)writer);
        } else {
            throw new IllegalArgumentException("Invalid writer: " + writer.getClass().getName());
        }
        serializer.write(node, output);
    }

    public static DOMImplementationRegistry getDomImplRegistry() {
        try {
            return DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return XmlUtils.getDocumentBuilderFactory(true, true);
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory(boolean namespaceAware) {
        return XmlUtils.getDocumentBuilderFactory(namespaceAware, true);
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory(boolean namespaceAware, boolean disableDtdXxe) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (namespaceAware) {
            documentBuilderFactory.setNamespaceAware(namespaceAware);
        }
        if (disableDtdXxe) {
            XmlUtils.setDocBuilderFeature(documentBuilderFactory, "http://xerces.apache.org/xerces-j/features.html#external-general-entities", false);
            XmlUtils.setDocBuilderFeature(documentBuilderFactory, "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
            XmlUtils.setDocBuilderFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
            XmlUtils.setDocBuilderFeature(documentBuilderFactory, "http://xerces.apache.org/xerces2-j/features.html#disallow-doctype-decl", true);
            XmlUtils.setDocBuilderFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        return documentBuilderFactory;
    }

    public static DocumentBuilder getDocumentBuilder() {
        return XmlUtils.getDocumentBuilder(true);
    }

    public static DocumentBuilder getDocumentBuilder(boolean namespaceAware) {
        try {
            return XmlUtils.getDocumentBuilderFactory(namespaceAware).newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static String getXPath(Node node) {
        LinkedList<String> list = new LinkedList<String>();
        while (node != null) {
            int idx;
            if (node.getNodeType() == 2) {
                list.add("@" + node.getNodeName());
                node = ((Attr)node).getOwnerElement();
                continue;
            }
            if (node.getNodeType() == 1) {
                idx = XmlUtils.getSiblingNumber(node);
                list.add("*[name()='" + node.getNodeName() + "'][" + idx + "]");
                node = node.getParentNode();
                continue;
            }
            if (node.getNodeType() == 3) {
                idx = XmlUtils.getSiblingNumber(node);
                list.add("text()[" + idx + "]");
                node = node.getParentNode();
                continue;
            }
            if (node.getNodeType() == 9) {
                node = null;
                continue;
            }
            throw new IllegalArgumentException("Unsupported node type: " + node.getNodeType() + " / " + node.getClass().getName());
        }
        StringBuilder xpath = new StringBuilder();
        while (!list.isEmpty()) {
            xpath.append("/").append((String)list.remove(list.size() - 1));
        }
        return xpath.toString();
    }

    public static int getSiblingNumber(Node node) {
        int idx = 1;
        for (Node s = node.getPreviousSibling(); s != null; s = s.getPreviousSibling()) {
            if (s.getNodeType() != node.getNodeType() || !s.getNodeName().equals(node.getNodeName())) continue;
            ++idx;
        }
        return idx;
    }

    public static <X extends Node> List<X> getChildNodes(Node node, Class<X> type) {
        NodeList nodelist = node.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node child = nodelist.item(i);
            if (!type.isInstance(child)) continue;
            list.add(child);
        }
        return list;
    }

    public static List<Node> toList(NodeList nodelist) {
        ArrayList<Node> list = new ArrayList<Node>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            list.add(nodelist.item(i));
        }
        return list;
    }

    public static List<Attr> toList(NamedNodeMap attrList) {
        ArrayList<Attr> list = new ArrayList<Attr>(attrList.getLength());
        for (int i = 0; i < attrList.getLength(); ++i) {
            list.add((Attr)attrList.item(i));
        }
        return list;
    }

    public static List<Node> toClonedList(NodeList nodelist, boolean deep) {
        ArrayList<Node> list = new ArrayList<Node>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            list.add(nodelist.item(i).cloneNode(deep));
        }
        return list;
    }

    public static List<Element> toElementList(NodeList nodelist) {
        ArrayList<Element> list = new ArrayList<Element>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            list.add((Element)nodelist.item(i));
        }
        return list;
    }

    public static List<Element> toClonedElementList(NodeList nodelist, boolean deep) {
        ArrayList<Element> list = new ArrayList<Element>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            list.add((Element)nodelist.item(i).cloneNode(deep));
        }
        return list;
    }

    public static Element createElement(String name, Node parent, Object ... attrs) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement(name);
        XmlUtils.setAttributes(element, attrs);
        parent.appendChild(element);
        return element;
    }

    public static Element createNSElement(String name, Node parent, Object ... attrs) {
        return XmlUtils.createNSElement(name, null, null, parent, attrs);
    }

    public static Element createNSElement(String name, String namespace, String prefix, Node parent, Object ... attrs) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS(namespace != null ? namespace : parent.getNamespaceURI(), name);
        if (prefix != null) {
            element.setPrefix(prefix);
        } else if (parent.getPrefix() != null) {
            element.setPrefix(parent.getPrefix());
        }
        XmlUtils.setAttributes(element, attrs);
        parent.appendChild(element);
        return element;
    }

    public static void setAttributes(Element element, Object ... attrs) {
        if (attrs.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of attributes");
        }
        for (int i = 0; i < attrs.length; i += 2) {
            element.setAttribute(attrs[i].toString(), attrs[i + 1].toString());
        }
    }

    public static TreeWalker createTreeWalker(Node node, int whatToShow) {
        return XmlUtils.createTreeWalker(node, whatToShow, null, true);
    }

    public static TreeWalker createTreeWalker(Node node, int whatToShow, NodeFilter nodeFilter, boolean entityReferenceExpansion) {
        DocumentTraversal documentTraversal = node instanceof Document ? (DocumentTraversal)((Object)node) : (DocumentTraversal)((Object)node.getOwnerDocument());
        return documentTraversal.createTreeWalker(node, whatToShow, nodeFilter, entityReferenceExpansion);
    }

    public static TreeWalker createElementTreeWalker(Node node) {
        return XmlUtils.createElementTreeWalker(node, true);
    }

    public static TreeWalker createElementTreeWalker(Node node, boolean entityReferenceExpansion) {
        return XmlUtils.createElementTreeWalker(node, null, entityReferenceExpansion);
    }

    public static TreeWalker createElementTreeWalker(Node node, NodeFilter nodeFilter, boolean entityReferenceExpansion) {
        return XmlUtils.createTreeWalker(node, 1, nodeFilter, entityReferenceExpansion);
    }

    public static XMLGregorianCalendar convertDate(Date date) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            xmlGregorianCalendar.setDay(c.get(5));
            xmlGregorianCalendar.setMonth(c.get(2));
            xmlGregorianCalendar.setYear(c.get(1));
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date convertDate(XMLGregorianCalendar date) {
        return new GregorianCalendar(date.getYear(), date.getMonth(), date.getDay()).getTime();
    }

    private <X> X getFromCache(WeakHashMap<Thread, SoftReference<X>> cache) {
        Thread t = Thread.currentThread();
        SoftReference<X> ref = cache.get(t);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    private <X> void cache(WeakHashMap<Thread, SoftReference<X>> cache, X value) {
        Thread t = Thread.currentThread();
        cache.put(t, new SoftReference<X>(value));
    }

    private static void setDocBuilderFeature(DocumentBuilderFactory documentBuilderFactory, String name, boolean value) {
        try {
            documentBuilderFactory.setFeature(name, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

