/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.commons.xml;

import com.aeontronix.commons.xml.XmlUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathUtils {
    private static final WeakHashMap<Thread, SoftReference<XPath>> xpathCache = new WeakHashMap();

    public static XPathFactory newXPathFactory() {
        return XPathFactory.newInstance();
    }

    public static XPathExpression newXPath(String xpath) throws XPathExpressionException {
        return XPathUtils.newXPathFactory().newXPath().compile(xpath);
    }

    public static XPathExpression newXPath(String xpath, final Map<String, String> namespaces) throws XPathExpressionException {
        XPath xp = XPathUtils.newXPathFactory().newXPath();
        xp.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return namespaces != null ? (String)namespaces.get(prefix) : null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaces == null) {
                    return null;
                }
                Iterator i = this.getPrefixes(namespaceURI);
                if (i.hasNext()) {
                    return (String)i.next();
                }
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                if (namespaces == null) {
                    return null;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (Map.Entry entry : namespaces.entrySet()) {
                    if (!((String)entry.getValue()).equals(namespaceURI)) continue;
                    list.add((String)entry.getKey());
                }
                return list.iterator();
            }
        });
        return xp.compile(xpath);
    }

    public static Object evalXPath(String xpath, InputSource source, QName type) throws XPathExpressionException {
        return XPathUtils.newXPath(xpath).evaluate(source, type);
    }

    public static Object evalXPath(String xpath, Node source, QName type) throws XPathExpressionException {
        return XPathUtils.newXPath(xpath).evaluate(source, type);
    }

    public static Node evalXPathNode(String xpath, InputSource source) throws XPathExpressionException {
        return (Node)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODE);
    }

    public static Node evalXPathNode(String xpath, Node source) throws XPathExpressionException {
        return (Node)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODE);
    }

    public static Element evalXPathElement(String xpath, InputSource source) throws XPathExpressionException {
        return (Element)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODE);
    }

    public static Element evalXPathElement(String xpath, Node source) throws XPathExpressionException {
        return (Element)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODE);
    }

    public static Boolean evalXPathBoolean(String xpath, InputSource source) throws XPathExpressionException {
        return (Boolean)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.BOOLEAN);
    }

    public static Boolean evalXPathBoolean(String xpath, Node source) throws XPathExpressionException {
        return (Boolean)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.BOOLEAN);
    }

    public static String evalXPathString(String xpath, InputSource source) throws XPathExpressionException {
        return (String)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.STRING);
    }

    public static String evalXPathString(String xpath, Node source) throws XPathExpressionException {
        Node node = XPathUtils.evalXPathNode(xpath, source);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    public static List<Node> evalXPathNodes(String xpath, InputSource source) throws XPathExpressionException {
        return XmlUtils.toList((NodeList)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODESET));
    }

    public static List<Node> evalXPathNodes(String xpath, Node source) throws XPathExpressionException {
        return XmlUtils.toList((NodeList)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODESET));
    }

    public static List<Element> evalXPathElements(String xpath, InputSource source) throws XPathExpressionException {
        return XmlUtils.toElementList((NodeList)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODESET));
    }

    public static List<Element> evalXPathElements(String xpath, Node source) throws XPathExpressionException {
        return XmlUtils.toElementList((NodeList)XPathUtils.newXPath(xpath).evaluate(source, XPathConstants.NODESET));
    }

    public static List<String> evalXPathTextElements(String xpath, InputSource source) throws XPathExpressionException {
        return XPathUtils.toTextContent(XPathUtils.evalXPathNodes(xpath, source));
    }

    public static List<String> evalXPathTextElements(String xpath, Node source) throws XPathExpressionException {
        return XPathUtils.toTextContent(XPathUtils.evalXPathNodes(xpath, source));
    }

    public static List<String> toTextContent(List<Node> nodes) {
        ArrayList<String> list = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            list.add(node.getTextContent());
        }
        return list;
    }

    private <X> X getFromCache(WeakHashMap<Thread, SoftReference<X>> cache) {
        Thread t = Thread.currentThread();
        SoftReference<X> ref = cache.get(t);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    private <X> void cache(WeakHashMap<Thread, SoftReference<X>> cache, X value) {
        Thread t = Thread.currentThread();
        cache.put(t, new SoftReference<X>(value));
    }
}

