/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk;

import com.aeontronix.anypointsdk.accessmanagement.AccessManagementClient;
import com.aeontronix.anypointsdk.amc.AMCClient;
import com.aeontronix.anypointsdk.auth.AnypointAuthenticationHandler;
import com.aeontronix.anypointsdk.auth.AnypointUPWAuthenticationHandler;
import com.aeontronix.anypointsdk.auth.credentials.AnypointCredentials;
import com.aeontronix.anypointsdk.auth.user.UserResponse;
import com.aeontronix.anypointsdk.cloudhub.CloudhubClient;
import com.aeontronix.anypointsdk.exchange.ExchangeClient;
import com.aeontronix.anypointsdk.monitoring.MonitoringClient;
import com.aeontronix.anypointsdk.organization.Organization;
import com.aeontronix.anypointsdk.organization.OrganizationData;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.json.JsonConverter;
import com.aeontronix.restclient.json.JsonConverterJacksonImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AnypointClient
implements AutoCloseable {
    public static final String PATH_USER = "/accounts/api/me";
    public static final String HEADER_ORG = "X-ANYPNT-ORG-ID";
    public static final String HEADER_ENV = "X-ANYPNT-ENV-ID";
    public static final String ANYPOINT_DEFAULT_URL = "https://anypoint.mulesoft.com";
    private final String anypointUrl;
    private final RESTClient restClient;
    private final RESTClientHost anypointRestClient;
    private CloudhubClient cloudhubClient;
    private AMCClient amcClient;
    private MonitoringClient monitoringClient;
    private AccessManagementClient accessManagementClient;
    private ExchangeClient exchangeClient;

    private AnypointClient(String anypointUrl, RESTClient restClient, RESTClientHost anypointRestClient) {
        this.anypointUrl = anypointUrl;
        this.restClient = restClient;
        this.anypointRestClient = anypointRestClient;
        this.cloudhubClient = new CloudhubClient(this);
        this.amcClient = new AMCClient(this);
        this.monitoringClient = new MonitoringClient(this);
        this.accessManagementClient = new AccessManagementClient(this);
        this.exchangeClient = new ExchangeClient(this);
    }

    public String getAnypointUrl() {
        return this.anypointUrl;
    }

    public RESTClient getRestClient() {
        return this.restClient;
    }

    public RESTClientHost getAnypointRestClient() {
        return this.anypointRestClient;
    }

    public CloudhubClient getCloudhubClient() {
        return this.cloudhubClient;
    }

    public AMCClient getCloudhub2Client() {
        return this.amcClient;
    }

    public MonitoringClient getMonitoringClient() {
        return this.monitoringClient;
    }

    public AccessManagementClient getAccessManagementClient() {
        return this.accessManagementClient;
    }

    public ExchangeClient getExchangeClient() {
        return this.exchangeClient;
    }

    public void setAccessManagementClient(AccessManagementClient accessManagementClient) {
        this.accessManagementClient = accessManagementClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UserResponse getUser() throws RESTException {
        return (UserResponse)this.anypointRestClient.get(PATH_USER, UserResponse.class);
    }

    public List<Organization> findOrganizations() throws RESTException {
        return this.getUser().getUser().getMemberOfOrganizations().stream().map(o -> new Organization(this, (OrganizationData)o)).collect(Collectors.toList());
    }

    public boolean testAuthentication() throws RESTException {
        try {
            this.getUser();
            return true;
        }
        catch (RESTException e) {
            if (e.isStatusCode401()) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Object[])new Object[]{this.restClient});
    }

    protected void buildRestClient(AnypointAuthenticationHandler authenticationHandler) {
    }

    public Optional<Organization> findOrganization(@NotNull String id) throws RESTException {
        return this.findOrganizations().stream().filter(v -> id.equals(v.getId())).findFirst();
    }

    public static class Builder {
        private String baseUrl = "https://anypoint.mulesoft.com";
        private ProxySettings proxySettings;
        private AuthenticationHandler authenticationHandler;
        private RESTClient restClient;
        private RESTClientHost anypointRestClient;

        Builder() {
        }

        public Builder anypointUrl(@NotNull String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder credentials(@NotNull AnypointCredentials credentials) {
            return this.authenticationHandler(credentials.toAuthenticationHandler());
        }

        public Builder usernamePasswordAuthentication(String username, String password) {
            this.authenticationHandler = new AnypointUPWAuthenticationHandler(username, password);
            return this;
        }

        public Builder authenticationHandler(@NotNull AuthenticationHandler authenticationHandler) {
            this.authenticationHandler = authenticationHandler;
            return this;
        }

        public Builder proxy(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public Builder restClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public Builder anypointRestClient(RESTClientHost anypointRestClient) {
            this.anypointRestClient = anypointRestClient;
            return this;
        }

        public AnypointClient build() {
            ObjectMapper objectMapper = null;
            if (this.restClient == null) {
                objectMapper = new ObjectMapper();
                objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                objectMapper.registerModule((Module)new Jdk8Module());
                objectMapper.registerModule((Module)new JavaTimeModule());
                objectMapper.registerModule((Module)new ParameterNamesModule());
                JsonConverterJacksonImpl jsonConverterJackson = new JsonConverterJacksonImpl(objectMapper);
                RESTClient.Builder builder = RESTClient.builder();
                if (this.proxySettings != null) {
                    builder = builder.proxy(this.proxySettings);
                }
                RESTClient.Builder jsonConverter = (RESTClient.Builder)builder.jsonConverter((JsonConverter)jsonConverterJackson);
                this.restClient = jsonConverter.build();
            }
            if (this.anypointRestClient == null) {
                RESTClientHostBuilder hostBuilder = this.restClient.host(this.baseUrl);
                if (this.authenticationHandler != null) {
                    hostBuilder.authenticationHandler(this.authenticationHandler);
                }
                this.anypointRestClient = hostBuilder.build();
            }
            AnypointClient anypointClient = new AnypointClient(this.baseUrl, this.restClient, this.anypointRestClient);
            if (this.authenticationHandler instanceof AnypointAuthenticationHandler) {
                ((AnypointAuthenticationHandler)this.authenticationHandler).setAnypointBaseUrl(this.baseUrl);
            }
            if (objectMapper != null) {
                objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("anypointClient", (Object)anypointClient));
            }
            return anypointClient;
        }
    }
}

