/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc;

import com.aeontronix.anypointsdk.application.AppUpdateStrategy;
import com.aeontronix.anypointsdk.application.ApplicationIdentifier;
import com.aeontronix.anypointsdk.application.deployment.ApplicationAssetRef;
import com.aeontronix.anypointsdk.application.deployment.ApplicationDeployment;
import com.aeontronix.anypointsdk.application.deployment.ApplicationHttp;
import com.aeontronix.anypointsdk.application.deployment.ApplicationIntegrations;
import com.aeontronix.anypointsdk.application.deployment.ApplicationLoggingService;
import com.aeontronix.anypointsdk.application.deployment.ApplicationPropertiesService;
import com.aeontronix.anypointsdk.application.deployment.ApplicationServices;
import com.aeontronix.anypointsdk.application.deployment.ApplicationState;
import com.aeontronix.anypointsdk.application.deployment.DeploymentSettings;
import com.aeontronix.anypointsdk.application.deployment.Inbound;
import com.aeontronix.anypointsdk.application.deployment.Jvm;
import com.aeontronix.anypointsdk.application.deployment.ObjectStoreV2;
import com.aeontronix.anypointsdk.application.deployment.ScopeLoggingConfigurationsItem;
import com.aeontronix.anypointsdk.application.deployment.Services;
import com.aeontronix.anypointsdk.application.deployment.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AMCAppDeploymentParameters {
    private boolean clustered;
    private String publicUrl;
    private String pathRewrite;
    private boolean lastMileSecurity;
    private boolean forwardSslSession;
    private String runtimeVersion;
    private AppUpdateStrategy updateStrategy = AppUpdateStrategy.ROLLING;
    private boolean disableAmLogForwarding;
    private boolean generateDefaultPublicUrl;
    private int replicas = 1;
    private String desiredState = "STARTED";
    private boolean objectStoreV2Enabled;
    private String vCores = "0.1";

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public String getPathRewrite() {
        return this.pathRewrite;
    }

    public void setPathRewrite(String pathRewrite) {
        this.pathRewrite = pathRewrite;
    }

    public boolean isLastMileSecurity() {
        return this.lastMileSecurity;
    }

    public void setLastMileSecurity(boolean lastMileSecurity) {
        this.lastMileSecurity = lastMileSecurity;
    }

    public boolean isForwardSslSession() {
        return this.forwardSslSession;
    }

    public void setForwardSslSession(boolean forwardSslSession) {
        this.forwardSslSession = forwardSslSession;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public AppUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(AppUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean isDisableAmLogForwarding() {
        return this.disableAmLogForwarding;
    }

    public void setDisableAmLogForwarding(boolean disableAmLogForwarding) {
        this.disableAmLogForwarding = disableAmLogForwarding;
    }

    public boolean isGenerateDefaultPublicUrl() {
        return this.generateDefaultPublicUrl;
    }

    public void setGenerateDefaultPublicUrl(boolean generateDefaultPublicUrl) {
        this.generateDefaultPublicUrl = generateDefaultPublicUrl;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public String getDesiredState() {
        return this.desiredState;
    }

    public void setDesiredState(String desiredState) {
        this.desiredState = desiredState;
    }

    public boolean isObjectStoreV2Enabled() {
        return this.objectStoreV2Enabled;
    }

    public void setObjectStoreV2Enabled(boolean objectStoreV2Enabled) {
        this.objectStoreV2Enabled = objectStoreV2Enabled;
    }

    public String getvCores() {
        return this.vCores;
    }

    public void setvCores(String vCores) {
        this.vCores = vCores;
    }

    public ApplicationDeployment toDataObject(String appName, String targetId, ApplicationIdentifier appId, Map<String, String> properties, Map<String, String> secureProperties) {
        ApplicationDeployment applicationData = new ApplicationDeployment();
        applicationData.setName(appName);
        applicationData.setLabels(Collections.singletonList("beta"));
        Target target = new Target();
        target.setProvider("MC");
        target.setTargetId(targetId);
        applicationData.setTarget(target);
        DeploymentSettings deploymentSettings = new DeploymentSettings();
        deploymentSettings.setClustered(this.clustered);
        deploymentSettings.setEnforceDeployingReplicasAcrossNodes(false);
        deploymentSettings.setJvm(new Jvm());
        deploymentSettings.setRuntimeVersion(this.runtimeVersion);
        deploymentSettings.setUpdateStrategy(this.updateStrategy.getJsonValue());
        deploymentSettings.setDisableAmLogForwarding(this.disableAmLogForwarding);
        deploymentSettings.setPersistentObjectStore(false);
        deploymentSettings.setGenerateDefaultPublicUrl(this.generateDefaultPublicUrl);
        ApplicationHttp http = new ApplicationHttp();
        Inbound inbound = new Inbound();
        inbound.setPublicUrl(this.publicUrl);
        inbound.setPathRewrite(this.pathRewrite);
        inbound.setLastMileSecurity(this.lastMileSecurity);
        inbound.setForwardSslSession(this.forwardSslSession);
        http.setInbound(inbound);
        deploymentSettings.setHttp(http);
        target.setDeploymentSettings(deploymentSettings);
        target.setReplicas(this.replicas);
        ApplicationState applicationConfig = new ApplicationState();
        ApplicationAssetRef ref = new ApplicationAssetRef();
        ref.setGroupId(appId.getGroupId());
        ref.setArtifactId(appId.getArtifactId());
        ref.setVersion(appId.getVersion());
        ref.setPackaging("jar");
        applicationConfig.setRef(ref);
        applicationConfig.setAssets(new ArrayList<Object>());
        applicationConfig.setDesiredState(this.desiredState);
        ApplicationServices services = new ApplicationServices();
        ApplicationPropertiesService applicationPropertiesService = new ApplicationPropertiesService();
        applicationPropertiesService.setApplicationName(appName);
        applicationPropertiesService.setProperties(properties);
        applicationPropertiesService.setSecureProperties(secureProperties);
        services.setMuleAgentApplicationPropertiesService(applicationPropertiesService);
        ApplicationLoggingService muleAgentLoggingService = new ApplicationLoggingService();
        muleAgentLoggingService.setScopeLoggingConfigurations(new ArrayList<ScopeLoggingConfigurationsItem>());
        services.setMuleAgentLoggingService(muleAgentLoggingService);
        applicationConfig.setServices(services);
        applicationData.setApplication(applicationConfig);
        ApplicationIntegrations integrations = new ApplicationIntegrations();
        integrations.setServices(new Services(new ObjectStoreV2(this.objectStoreV2Enabled)));
        applicationConfig.setIntegrations(integrations);
        applicationConfig.setvCores(this.vCores);
        return applicationData;
    }

    @NotNull
    private static HashMap<String, Object> putMap(HashMap<String, Object> map, String key) {
        HashMap<String, Object> childMap = new HashMap<String, Object>();
        map.put(key, childMap);
        return childMap;
    }
}

