/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.amc;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.amc.AMCAppDeploymentParameters;
import com.aeontronix.anypointsdk.amc.AMCApplicationListResponse;
import com.aeontronix.anypointsdk.amc.AMCDeploymentResponse;
import com.aeontronix.anypointsdk.application.ApplicationIdentifier;
import com.aeontronix.anypointsdk.application.ApplicationSource;
import com.aeontronix.anypointsdk.application.FileApplicationSource;
import com.aeontronix.anypointsdk.application.deployment.ApplicationDeployment;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTClientHostPathBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMCClient {
    private static final Logger logger = LoggerFactory.getLogger(AMCClient.class);
    private RESTClientHost restClient;
    private AnypointClient anypointClient;

    public AMCClient(AnypointClient anypointClient) {
        this.restClient = anypointClient.getAnypointRestClient();
        this.anypointClient = anypointClient;
    }

    public List<ApplicationDeployment> listDeployments(String orgId, String envId) throws RESTException {
        return ((AMCApplicationListResponse)AMCClient.deploymentPath(this.restClient.get(), orgId, envId).build().executeAndConvertToObject(AMCApplicationListResponse.class)).getItems();
    }

    public Optional<ApplicationDeployment> findDeploymentByName(String orgId, String envId, String name) throws RESTException {
        return this.listDeployments(orgId, envId).stream().filter(a -> a.getName().equals(name)).findFirst();
    }

    public ApplicationDeployment findDeploymentById(String orgId, String envId, String appId) throws RESTException {
        return (ApplicationDeployment)AMCClient.deploymentPath(this.restClient.get(), orgId, envId).path(appId, true).build().executeAndConvertToObject(ApplicationDeployment.class);
    }

    public AMCDeploymentResponse deployApplication(AMCAppDeploymentParameters params, String appName, String orgId, String envId, String target, ApplicationSource applicationSource, Map<String, String> properties, HashSet<String> securePropertiesKeys, String buildNumber) throws RESTException, IOException {
        try {
            RESTClientHostPathBuilder method;
            ApplicationIdentifier appId = applicationSource.getApplicationIdentifier();
            appId.setGroupId(orgId);
            if (appId.getVersion().toLowerCase().endsWith("-snapshot")) {
                appId.setVersion(appId.getVersion() + "-" + (buildNumber != null ? buildNumber : DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now())));
            }
            if (applicationSource instanceof FileApplicationSource) {
                logger.info("Publishing archive to exchange: " + appId);
                this.anypointClient.getExchangeClient().createAsset(orgId, appId.getArtifactId(), appId.getVersion(), appName).file("jar", "mule-application", null, applicationSource.getFilename(), applicationSource.getFile()).execute();
                logger.info("Finished publishing archive to exchange: " + appId);
            }
            if (params.getRuntimeVersion() == null) {
                params.setRuntimeVersion(this.anypointClient.getCloudhubClient().findDefaultCHMuleVersion().getVersion());
            }
            Optional<ApplicationDeployment> existing = this.findDeploymentByName(orgId, envId, appName);
            HashMap<String, String> insecureProperties = new HashMap<String, String>();
            HashMap<String, String> secureProperties = new HashMap<String, String>();
            if (existing.isPresent()) {
                String deploymentId = existing.get().getId();
                Iterator<Map.Entry<String, String>> existingDeployment = this.findDeploymentById(orgId, envId, deploymentId);
                insecureProperties.putAll(((ApplicationDeployment)((Object)existingDeployment)).getNonSecureProperties());
                secureProperties.putAll(((ApplicationDeployment)((Object)existingDeployment)).getSecureProperties());
                method = AMCClient.deploymentPath(this.restClient.patch(), orgId, envId).path(deploymentId, true);
            } else {
                method = AMCClient.deploymentPath(this.restClient.post(), orgId, envId);
            }
            HashSet existingInsecureKeys = new HashSet(insecureProperties.keySet());
            for (String existingInsecureKey : existingInsecureKeys) {
                if (!securePropertiesKeys.contains(existingInsecureKey)) continue;
                secureProperties.put(existingInsecureKey, (String)insecureProperties.remove(existingInsecureKey));
            }
            for (Map.Entry<String, String> e : properties.entrySet()) {
                String key = e.getKey();
                if (!securePropertiesKeys.contains(key) && !secureProperties.keySet().contains(key)) {
                    insecureProperties.put(key, e.getValue());
                    continue;
                }
                secureProperties.put(key, e.getValue());
            }
            ApplicationDeployment applicationData = params.toDataObject(appName, target, appId, insecureProperties, secureProperties);
            return new AMCDeploymentResponse(this, orgId, envId, (ApplicationDeployment)method.build().jsonBody((Object)applicationData).executeAndConvertToObject(ApplicationDeployment.class));
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static RESTClientHostPathBuilder deploymentPath(RESTClientHostPathBuilder builder, String orgId, String envId) {
        return builder.path("/amc/application-manager/api/v2/organizations/").path(orgId, true).path("/environments/").path(envId, true).path("/deployments");
    }
}

