/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.application;

import com.aeontronix.anypointsdk.amc.AMCDeploymentFailedException;
import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.restclient.RESTException;
import java.time.Duration;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeploymentResponse {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResponse.class);

    public void waitDeploymentComplete(Duration timeout, long retryDelay) throws AMCDeploymentFailedException {
        LocalDateTime timeLimit = LocalDateTime.now().plus(timeout);
        while (LocalDateTime.now().isBefore(timeLimit)) {
            try {
                if (this.checkDeploymentComplete()) {
                    return;
                }
            }
            catch (RESTException e) {
                logger.warn("Failed to retrieve application status: " + e.getMessage(), (Throwable)e);
            }
            ThreadUtils.sleep((long)retryDelay);
        }
        throw new AMCDeploymentFailedException("Deployment time limit has been reached, considering deployment failed");
    }

    public abstract boolean checkDeploymentComplete() throws AMCDeploymentFailedException, RESTException;
}

