/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.application;

import com.aeontronix.anypointsdk.application.ApplicationIdentifier;
import com.aeontronix.anypointsdk.application.ApplicationSource;
import com.aeontronix.commons.exception.UnexpectedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileApplicationSource
extends ApplicationSource {
    private static final Logger logger = LoggerFactory.getLogger(FileApplicationSource.class);
    private File file;

    public FileApplicationSource(File file) {
        block9: {
            this.file = file;
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry artJson = zipFile.getEntry("META-INF/mule-artifact/mule-artifact.json");
                if (artJson == null) break block9;
                try (InputStream is = zipFile.getInputStream(artJson);){
                    String[] name;
                    ObjectNode jsonNode = (ObjectNode)new ObjectMapper().readTree(is);
                    JsonNode nameJson = jsonNode.get("name");
                    if (nameJson != null && !nameJson.isNull() && (name = nameJson.textValue().split(":")).length == 3) {
                        this.applicationIdentifier = new ApplicationIdentifier(name[0], name[1], name[2]);
                        logger.debug("Loaded ApplicationIdentifier from archive: " + this.applicationIdentifier);
                    }
                }
            }
            catch (IOException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }
}

