/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.auth;

import com.aeontronix.anypointsdk.auth.AnypointAuthenticationHandler;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.ResponseConversionException;
import com.aeontronix.restclient.auth.AuthenticationException;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

public class AnypointClientCredentialsAuthenticationHandler
extends AnypointAuthenticationHandler {
    private String clientId;
    private String clientSecret;
    private LocalDateTime expires;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AnypointClientCredentialsAuthenticationHandler(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public boolean isRefreshRequired() {
        return this.expires == null || LocalDateTime.now().isAfter(this.expires);
    }

    public boolean isRefreshable() {
        return true;
    }

    public void refreshCredential(RESTClient restClient) throws RESTException, AuthenticationException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("grant_type", "client_credentials");
        payload.put("client_id", this.clientId);
        payload.put("client_secret", this.clientSecret);
        try (RESTResponse response = restClient.post(new URLBuilder(this.anypointBaseUrl).path("/accounts/api/v2/oauth2/token").toUri()).jsonBody(payload).execute();){
            Map res = (Map)response.toObject(Map.class);
            this.expires = LocalDateTime.now().plus(((Integer)res.get("expires_in")).intValue(), ChronoUnit.SECONDS);
            this.setBearerToken((String)res.get("access_token"));
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (ResponseConversionException e) {
            throw new AuthenticationException("Unable to parse login response: " + e.getMessage(), (Throwable)e);
        }
    }
}

