/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.auth;

import com.aeontronix.anypointsdk.auth.AnypointAuthenticationHandler;
import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.ResponseConversionException;
import com.aeontronix.restclient.auth.AuthenticationException;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnypointUPWAuthenticationHandler
extends AnypointAuthenticationHandler {
    private String username;
    private String password;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AnypointUPWAuthenticationHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean isRefreshRequired() {
        return this.authzHeader == null;
    }

    public boolean isRefreshable() {
        return true;
    }

    public void refreshCredential(RESTClient restClient) throws RESTException, AuthenticationException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("username", this.username);
        payload.put("password", this.password);
        try (RESTResponse response = restClient.post(new URLBuilder(this.anypointBaseUrl).path("/accounts/login").toUri()).jsonBody(payload).execute();){
            Map res = (Map)response.toObject(Map.class);
            String accessToken = (String)res.get("access_token");
            if (accessToken == null) {
                throw new AuthenticationException(res.containsKey("url") ? "Unable to authenticate, MFA is enabled for account." : "Authentication failed, bearer token wasn't returned by anypoint", null);
            }
            this.setBearerToken(accessToken);
        }
        catch (IOException e) {
            throw new RESTException(e.getMessage(), (Throwable)e);
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (ResponseConversionException e) {
            throw new AuthenticationException("Unable to parse login response: " + e.getMessage(), (Throwable)e);
        }
    }
}

