/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.exchange;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.apimanager.APIContractData;
import com.aeontronix.anypointsdk.exchange.CreateExchangeAssetRequest;
import com.aeontronix.anypointsdk.exchange.ExchangeClientApplication;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.PaginatedResponse;
import com.aeontronix.restclient.RESTClientHostPathBuilder;
import com.aeontronix.restclient.RESTClientRequestBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExchangeClient {
    private AnypointClient anypointClient;

    public ExchangeClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
    }

    public CreateExchangeAssetRequest createAsset() {
        return new CreateExchangeAssetRequest(this.anypointClient);
    }

    public CreateExchangeAssetRequest createAsset(String orgId, String assetId, String version, String name) {
        return new CreateExchangeAssetRequest(this.anypointClient, orgId, assetId, version, name);
    }

    public List<ExchangeClientApplication> listClientApplications(String orgId) throws RESTException {
        List list;
        block8: {
            PaginatedResponse response = ((RESTClientRequestBuilder)((RESTClientRequestBuilder)this.anypointClient.getAnypointRestClient().get().path("/exchange/api/v1/organizations").path(orgId).path("/applications").build().paginate()).pageValuesPath("")).executePaginated(ExchangeClientApplication.class);
            try {
                list = response.toList();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RESTException((Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }

    public ExchangeClientApplication findClientApplicationById(String orgId, String id) throws RESTException {
        try {
            return (ExchangeClientApplication)this.anypointClient.getAnypointRestClient().get().path("/exchange/api/v1/organizations").path(orgId).path("/applications").path(id).build().executeAndConvertToObject(ExchangeClientApplication.class);
        }
        catch (RESTException e) {
            if (e.getStatusCode() == 403) {
                throw new RESTException("Client application either doesn't exist or not authorized to access", Integer.valueOf(e.getStatusCode()), e.getReason());
            }
            throw e;
        }
    }

    public ExchangeClientApplication createClientApplication(@NotNull String orgId, @NotNull String name, String url, String description, List<String> redirectUri, List<String> grantTypes, String apiEndpoints, String accessedAPIInstanceId) throws JsonConvertionException, RESTException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("name", name);
        req.put("description", description != null ? description : "");
        req.put("redirectUri", redirectUri);
        req.put("apiEndpoints", false);
        req.put("grantTypes", grantTypes);
        req.put("url", url);
        RESTClientHostPathBuilder builder = this.anypointClient.getAnypointRestClient().post().path("/exchange/api/v1/organizations/").path(orgId).path("/applications");
        if (accessedAPIInstanceId != null) {
            builder.queryParam("apiInstanceId", accessedAPIInstanceId);
        }
        return (ExchangeClientApplication)builder.build().jsonBody(req).executeAndConvertToObject(ExchangeClientApplication.class);
    }

    public APIContractData createAPIContract(String applicationId, String apiId, String organizationId, String environmentId, boolean acceptedTerms, String groupId, String assetId, String version, String productAPIVersion, Long tierId) throws RESTException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("apiId", apiId);
        req.put("environmentId", environmentId);
        req.put("acceptedTerms", acceptedTerms);
        req.put("organizationId", organizationId);
        req.put("groupId", groupId);
        req.put("assetId", assetId);
        req.put("version", version);
        req.put("productAPIVersion", productAPIVersion);
        if (tierId != null) {
            req.put("requestedTierId", tierId);
        }
        try {
            return (APIContractData)this.anypointClient.getAnypointRestClient().post().path("/exchange/api/v1/organizations/").path(organizationId).path("/applications/").path(applicationId).path("/contracts").build().jsonBody(req).executeAndConvertToObject(APIContractData.class);
        }
        catch (JsonConvertionException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

