/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.monitoring;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.monitoring.MetricsQueryResponse;
import com.aeontronix.anypointsdk.monitoring.MetricsType;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClientHost;
import com.aeontronix.restclient.RESTException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;

public class MonitoringClient {
    private final RESTClientHost restClient;
    private AnypointClient anypointClient;

    public MonitoringClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
        this.restClient = anypointClient.getAnypointRestClient();
    }

    public MetricsQueryResponse getApplicationMetrics(MetricsType metricsType, String orgId, String envId, String appId, LocalDateTime from, LocalDateTime to) throws RESTException {
        ZoneId systemZoneId = ZoneId.systemDefault();
        long fromEpoch = from.toInstant(ZoneOffset.from(ZoneOffset.UTC)).toEpochMilli();
        long toEpoch = to.toInstant(ZoneOffset.from(ZoneOffset.UTC)).toEpochMilli();
        String queryStr = "SELECT " + metricsType.getSelect() + " WHERE (\"org_id\" = '" + orgId + "' AND \"env_id\" = '" + envId + "' AND \"app_id\" = '" + appId + "') AND time >= " + fromEpoch + "ms and time <= " + toEpoch + "ms GROUP BY time(1m) " + metricsType.getBy() + " fill(linear) tz('" + systemZoneId + "')";
        return this.queryApplicationMetrics(queryStr);
    }

    public MetricsQueryResponse queryApplicationMetrics(String query) throws RESTException {
        String url;
        String database;
        try {
            Map bootData = (Map)this.restClient.get("monitoring/api/visualizer/api/bootdata", Map.class);
            Map influx = (Map)((Map)((Map)bootData.get("Settings")).get("datasources")).get("influxdb");
            database = (String)influx.get("database");
            url = (String)influx.get("url");
        }
        catch (NullPointerException e) {
            throw new UnexpectedException("Invalid boot data (it might be anypoint changed how graphs load in which case this logic needs updating)", (Throwable)e);
        }
        return (MetricsQueryResponse)this.restClient.get().path("monitoring/api/visualizer/").path(url).path("query").queryParam("db", database).queryParam("q", query).queryParam("epoch", "ms").build().executeAndConvertToObject(MetricsQueryResponse.class);
    }
}

