/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.anypointsdk.organization;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.organization.Environment;
import com.aeontronix.anypointsdk.organization.EnvironmentData;
import com.aeontronix.anypointsdk.organization.OrganizationData;
import com.aeontronix.anypointsdk.organization.SubscriptionData;
import com.aeontronix.restclient.PaginatedResponse;
import com.aeontronix.restclient.RESTException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class Organization {
    private AnypointClient client;
    private OrganizationData data;

    public Organization(AnypointClient client, OrganizationData data) {
        this.client = client;
        this.data = data;
    }

    public OrganizationData getData() {
        return this.data;
    }

    public boolean isIsAutomaticAdminPromotionExempt() {
        return this.data.isIsAutomaticAdminPromotionExempt();
    }

    public List<String> getSubOrganizationIds() {
        return this.data.getSubOrganizationIds();
    }

    public String getClientId() {
        return this.data.getClientId();
    }

    public boolean isIsRoot() {
        return this.data.isIsRoot();
    }

    public SubscriptionData getSubscription() {
        return this.data.getSubscription();
    }

    public String getOwnerId() {
        return this.data.getOwnerId();
    }

    public boolean isIsFederated() {
        return this.data.isIsFederated();
    }

    public String getCreatedAt() {
        return this.data.getCreatedAt();
    }

    public String getOrgType() {
        return this.data.getOrgType();
    }

    public Object getParentName() {
        return this.data.getParentName();
    }

    public boolean isIsMaster() {
        return this.data.isIsMaster();
    }

    public String getDomain() {
        return this.data.getDomain();
    }

    public String getName() {
        return this.data.getName();
    }

    public String getId() {
        return this.data.getId();
    }

    public String getMfaRequired() {
        return this.data.getMfaRequired();
    }

    public String getIdproviderId() {
        return this.data.getIdproviderId();
    }

    public String getUpdatedAt() {
        return this.data.getUpdatedAt();
    }

    public List<Environment> findEnvironments() throws RESTException {
        List<Environment> list;
        block8: {
            PaginatedResponse response = this.client.getAnypointRestClient().get().path("/accounts/api/organizations/").path(this.data.getId(), true).path("environments").build().executePaginated(EnvironmentData.class, "offset", "limit", "/data");
            try {
                list = response.toList().stream().map(Environment::new).collect(Collectors.toList());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RESTException((Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }
}

