/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.accessmanagement;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.restclient.RESTException;

import java.util.List;

public class AccessManagementClient {
    private AnypointClient anypointClient;

    public AccessManagementClient(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
    }

    public List<ConnectedAppData> findConnectedApps() throws RESTException {
        return anypointClient.getAnypointRestClient().get("accounts/api/connectedApplications")
                .paginate().pageValuesPath("/data")
                .executePaginated(ConnectedAppData.class).toList();
    }
}
