/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.LinkedHashMap;
import java.util.Map;

public class AMCApplicationListItem {
    @JsonProperty("application")
    private final Map<String, String> application = new LinkedHashMap<>();

    @JsonProperty("lastModifiedDate")
    private long lastModifiedDate;

    @JsonProperty("name")
    private String name;

    @JsonProperty("id")
    private String id;

    @JsonProperty("creationDate")
    private long creationDate;

    @JsonProperty("target")
    private AMCApplicationTarget target;

    @JsonProperty("status")
    private String status;

    public void setApplication(Map<String, String> application) {
        this.application.clear();
        this.application.putAll(application);
    }

    public Map<String, String> getApplication() {
        return application;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public long getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getCreationDate() {
        return creationDate;
    }

    public void setTarget(AMCApplicationTarget target) {
        this.target = target;
    }

    public AMCApplicationTarget getTarget() {
        return target;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }

    @JsonIgnore
    public String getApplicationStatus() {
        return application.get("status");
    }

    @JsonIgnore
    public void setApplicationStatus(String status) {
        application.put("status", status);
    }

    @Override
    public String toString() {
        return
                "Response{" +
                        "application = '" + application + '\'' +
                        ",lastModifiedDate = '" + lastModifiedDate + '\'' +
                        ",name = '" + name + '\'' +
                        ",id = '" + id + '\'' +
                        ",creationDate = '" + creationDate + '\'' +
                        ",target = '" + target + '\'' +
                        ",status = '" + status + '\'' +
                        ",applicationStatus = '" + getApplicationStatus() + '\'' +
                        "}";
    }
}
