/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application;

import com.aeontronix.anypointsdk.amc.AMCDeploymentFailedException;
import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.restclient.RESTException;
import org.slf4j.Logger;

import java.time.Duration;
import java.time.LocalDateTime;

import static org.slf4j.LoggerFactory.getLogger;

public abstract class DeploymentResponse {
    private static final Logger logger = getLogger(DeploymentResponse.class);

    public void waitDeploymentComplete(Duration timeout, long retryDelay) throws AMCDeploymentFailedException {
        LocalDateTime timeLimit = LocalDateTime.now().plus(timeout);
        while (LocalDateTime.now().isBefore(timeLimit)) {
            try {
                if (checkDeploymentComplete()) {
                    return;
                }
            } catch (RESTException e) {
                logger.warn("Failed to retrieve application status: " + e.getMessage(), e);
            }
            ThreadUtils.sleep(retryDelay);
        }
        throw new AMCDeploymentFailedException("Deployment time limit has been reached, considering deployment failed");
    }

    public abstract boolean checkDeploymentComplete() throws AMCDeploymentFailedException, RESTException;
}
