/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application;

import com.aeontronix.commons.exception.UnexpectedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import static org.slf4j.LoggerFactory.getLogger;

public class FileApplicationSource extends ApplicationSource {
    private static final Logger logger = getLogger(FileApplicationSource.class);
    private File file;

    public FileApplicationSource(File file) {
        this.file = file;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry artJson = zipFile.getEntry("META-INF/mule-artifact/classloader-model.json");
            if (artJson != null) {
                try (InputStream is = zipFile.getInputStream(artJson)) {
                    final ObjectNode jsonNode = (ObjectNode) new ObjectMapper().readTree(is);
                    final JsonNode artifactCoordinates = jsonNode.get("artifactCoordinates");
                    JsonNode groupId = artifactCoordinates.get("groupId");
                    JsonNode artifactId = artifactCoordinates.get("artifactId");
                    JsonNode version = artifactCoordinates.get("version");
                    applicationIdentifier = new ApplicationIdentifier(groupId.asText(), artifactId.asText(), version.asText());
                    logger.debug("Loaded ApplicationIdentifier from archive: " + applicationIdentifier);
                }
            }
        } catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public File getFile() {
        return file;
    }

    @Override
    public String getFilename() {
        return file.getName();
    }
}
