/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application.deployment;

import java.util.Map;

public class ApplicationDeployment {
    private ApplicationDeploymentData data;

    public ApplicationDeployment(ApplicationDeploymentData data) {
        this.data = data;
    }

    public ApplicationDeploymentData getData() {
        return data;
    }

    public Map<String, String> getLoggingLevels() {
        return getMuleAgentLoggingService().getLogLevels();
    }

    public void setLoggingLevels(Map<String, String> loggingLevels) {
        getMuleAgentLoggingService().setLogLevels(loggingLevels);
    }

    private ApplicationLoggingService getMuleAgentLoggingService() {
        return data.getApplicationState(true).getServices(true).getMuleAgentLoggingService(true);
    }
}
