/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplicationLoggingService {

    @JsonProperty("artifactName")
    private String artifactName;

    @JsonProperty("scopeLoggingConfigurations")
    private List<ScopeLoggingConfigurationsItem> scopeLoggingConfigurations;

    public String getArtifactName() {
        return artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    @JsonIgnore
    public synchronized Map<String, String> getLogLevels() {
        return getScopeLoggingConfigurations(true).stream()
                .collect(Collectors.toMap(ScopeLoggingConfigurationsItem::getScope, ScopeLoggingConfigurationsItem::getLogLevel));
    }

    @JsonIgnore
    public synchronized void setLogLevels(Map<String, String> logLevels) {
        getScopeLoggingConfigurations(true).clear();
        for (Map.Entry<String, String> e : logLevels.entrySet()) {
            scopeLoggingConfigurations.add(new ScopeLoggingConfigurationsItem(e.getKey(), e.getValue()));
        }
    }

    public List<ScopeLoggingConfigurationsItem> getScopeLoggingConfigurations(boolean create) {
        if (scopeLoggingConfigurations == null && create) {
            scopeLoggingConfigurations = new ArrayList<>();
        }
        return scopeLoggingConfigurations;
    }

    public List<ScopeLoggingConfigurationsItem> getScopeLoggingConfigurations() {
        return scopeLoggingConfigurations;
    }

    public void setScopeLoggingConfigurations(List<ScopeLoggingConfigurationsItem> scopeLoggingConfigurations) {
        this.scopeLoggingConfigurations = scopeLoggingConfigurations;
    }
}
