/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application.deployment;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

public class ApplicationState {
	@JsonProperty("status")
	private String status;

	@JsonProperty("desiredState")
	private String desiredState;

	@JsonProperty("ref")
	private ApplicationAssetRef ref;

	@JsonProperty("assets")
	private List<Object> assets;

	@JsonProperty("configuration")
	private ApplicationServices services;

	@JsonProperty("integrations")
	private ApplicationIntegrations integrations;

	@JsonProperty("vCores")
	private String vCores;

	public String getDesiredState() {
		return desiredState;
	}

	public void setDesiredState(String desiredState) {
		this.desiredState = desiredState;
	}

	public ApplicationAssetRef getRef() {
		return ref;
	}

	public void setRef(ApplicationAssetRef ref) {
		this.ref = ref;
	}

	public List<Object> getAssets() {
		return assets;
	}

	public void setAssets(List<Object> assets) {
		this.assets = assets;
	}

    public ApplicationServices getServices(boolean create) {
        if (services == null && create) {
            services = new ApplicationServices();
        }
        return services;
    }

	public ApplicationServices getServices() {
		return services;
	}

	public void setServices(ApplicationServices services) {
		this.services = services;
	}

	public ApplicationIntegrations getIntegrations() {
		return integrations;
	}

	public void setIntegrations(ApplicationIntegrations integrations) {
		this.integrations = integrations;
	}

	public String getvCores() {
		return vCores;
	}

	public void setvCores(String vCores) {
		this.vCores = vCores;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
}
