/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.amc.application.deployment;

import com.fasterxml.jackson.annotation.JsonProperty;

public class DeploymentSettings {

    @JsonProperty("jvm")
    private Jvm jvm;

    @JsonProperty("updateStrategy")
    private String updateStrategy;

    @JsonProperty("runtimeVersion")
    private String runtimeVersion;

    @JsonProperty("persistentObjectStore")
    private boolean persistentObjectStore;

    @JsonProperty("disableAmLogForwarding")
    private boolean disableAmLogForwarding;

    @JsonProperty("clustered")
    private boolean clustered;

    @JsonProperty("http")
    private ApplicationHttp http;

    @JsonProperty("enforceDeployingReplicasAcrossNodes")
    private boolean enforceDeployingReplicasAcrossNodes;

    @JsonProperty("generateDefaultPublicUrl")
    private boolean generateDefaultPublicUrl;

    public Jvm getJvm() {
        return jvm;
    }

    public void setJvm(Jvm jvm) {
        this.jvm = jvm;
    }

    public String getUpdateStrategy() {
        return updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public String getRuntimeVersion() {
        return runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public boolean isPersistentObjectStore() {
        return persistentObjectStore;
    }

    public void setPersistentObjectStore(boolean persistentObjectStore) {
        this.persistentObjectStore = persistentObjectStore;
    }

    public boolean isDisableAmLogForwarding() {
        return disableAmLogForwarding;
    }

    public void setDisableAmLogForwarding(boolean disableAmLogForwarding) {
        this.disableAmLogForwarding = disableAmLogForwarding;
    }

    public boolean isClustered() {
        return clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public ApplicationHttp getHttp() {
        return http;
    }

    public void setHttp(ApplicationHttp http) {
        this.http = http;
    }

    public boolean isEnforceDeployingReplicasAcrossNodes() {
        return enforceDeployingReplicasAcrossNodes;
    }

    public void setEnforceDeployingReplicasAcrossNodes(boolean enforceDeployingReplicasAcrossNodes) {
        this.enforceDeployingReplicasAcrossNodes = enforceDeployingReplicasAcrossNodes;
    }

    public boolean isGenerateDefaultPublicUrl() {
        return generateDefaultPublicUrl;
    }

    public void setGenerateDefaultPublicUrl(boolean generateDefaultPublicUrl) {
        this.generateDefaultPublicUrl = generateDefaultPublicUrl;
    }
}
