package com.aeontronix.anypointsdk.auth;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.RESTResponse;
import com.aeontronix.restclient.ResponseConversionException;
import com.aeontronix.restclient.auth.AuthenticationException;
import com.aeontronix.restclient.json.JsonConvertionException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnypointUPWAuthenticationHandler extends AnypointAuthenticationHandler {
    private String username;
    private String password;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AnypointUPWAuthenticationHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isRefreshRequired() {
        return authzHeader == null;
    }

    @Override
    public boolean isRefreshable() {
        return true;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void refreshCredential(RESTClient restClient) throws RESTException, AuthenticationException {
        final HashMap<Object, Object> payload = new HashMap<>();
        payload.put("username", username);
        payload.put("password", password);
        try (final RESTResponse response = restClient.post(new URLBuilder(anypointBaseUrl)
                        .path("/accounts/login").toUri())
                .jsonBody(payload).execute()) {
            final Map<String, String> res = response.toObject(Map.class);
            String accessToken = res.get("access_token");
            if (accessToken == null) {
                throw new AuthenticationException(res.containsKey("url") ? "Unable to authenticate, MFA is enabled for account." : "Authentication failed, bearer token wasn't returned by anypoint", null);
            }
            setBearerToken(accessToken);
        } catch (IOException e) {
            throw new RESTException(e.getMessage(), e);
        } catch (JsonConvertionException e) {
            throw new UnexpectedException(e);
        } catch (ResponseConversionException e) {
            throw new AuthenticationException("Unable to parse login response: " + e.getMessage(), e);
        }
    }
}
