/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.auth.credentials;

import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.auth.BearerTokenAuthenticationHandler;

public class AnypointBearerTokenCredentials implements AnypointCredentials {
    private String bearerToken;

    public AnypointBearerTokenCredentials() {
    }

    public AnypointBearerTokenCredentials(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getBearerToken() {
        return bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public AuthenticationHandler toAuthenticationHandler() {
        return new BearerTokenAuthenticationHandler(bearerToken);
    }
}
