/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.auth.credentials;

import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = AnypointBearerTokenCredentials.class, name = "bearer"),
        @JsonSubTypes.Type(value = AnypointUPWCredentials.class, name = "upw"),
        @JsonSubTypes.Type(value = AnypointClientCredentials.class, name = "client")
})
public interface AnypointCredentials {
    AuthenticationHandler toAuthenticationHandler();
}
