/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.auth.credentials;

import com.aeontronix.anypointsdk.auth.AnypointUPWAuthenticationHandler;
import com.aeontronix.restclient.auth.AuthenticationHandler;

public class AnypointUPWCredentials implements AnypointCredentials {
    private String username;
    private String password;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public AuthenticationHandler toAuthenticationHandler() {
        return new AnypointUPWAuthenticationHandler(username, password);
    }
}
