/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.exception.UnexpectedException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import picocli.CommandLine;

@CommandLine.Command
public class AbstractCmd {
    @CommandLine.ParentCommand
    private AbstractCmd parent;

    public AbstractCmd getParent() {
        return parent;
    }

    public AnypointClient getClient() {
        return parent.getClient();
    }

    protected void writeResult(Object obj) {
        try {
            System.out.println(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(obj));
        } catch (JsonProcessingException e) {
            throw new UnexpectedException(e);
        }
    }
}
