/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.amc.AMCAppDeploymentParameters;
import com.aeontronix.anypointsdk.amc.AMCDeploymentResponse;
import com.aeontronix.anypointsdk.amc.application.ExchangeApplicationSource;
import picocli.CommandLine;
import picocli.CommandLine.Option;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;

@CommandLine.Command(name = "deploy")
public class CH2DeployAppCmd extends AbstractCmd implements Callable<Integer> {
    @Option(names = {"-a", "--appname"}, required = true)
    private String appName;
    @Option(names = {"-t", "--target"}, required = true)
    private String targetId;
    @Option(names = {"-o", "--org"}, required = true)
    private String orgId;
    @Option(names = {"-e", "--env"}, required = true)
    private String envId;
    @Option(names = {"-ao", "--asset-org"})
    private String assetOrgId;
    @Option(names = {"-i", "--asset-artifact-id"}, required = true)
    private String assetArtifactId;
    @Option(names = {"-v", "--asset-version"}, required = true)
    private String assetVersion;
    @Option(names = {"--force"}, required = false)
    private boolean force;

    public CH2DeployAppCmd() {
    }

    @Override
    public Integer call() throws Exception {
        AnypointClient client = getClient();
        final AMCAppDeploymentParameters req = new AMCAppDeploymentParameters();
        AMCDeploymentResponse response = client.getAMCClient().deployApplication(req, appName, orgId, envId, targetId,
                new ExchangeApplicationSource(assetOrgId != null ? assetOrgId : orgId, assetArtifactId, assetVersion),
                new HashMap<>(), new HashSet<>(), null, force);
        response.waitDeploymentComplete(Duration.ofMinutes(5), 2500);
        return 0;
    }
}
