/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.amc.application.deployment.ApplicationDeploymentData;
import picocli.CommandLine;

import java.util.List;
import java.util.concurrent.Callable;

@CommandLine.Command(name = "listapps")
public class CH2ListAppsCmd extends AbstractCmd implements Callable<Integer> {
    @CommandLine.Parameters
    private String orgId;
    @CommandLine.Parameters
    private String envId;

    @Override
    public Integer call() throws Exception {
        AnypointClient client = getClient();
        List<ApplicationDeploymentData> apps = client.getAMCClient().listDeployments(orgId, envId);
        writeResult(apps);
        return 0;
    }
}
