/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.export.AnypointExportFile;
import com.aeontronix.anypointsdk.export.ExportFilters;
import picocli.CommandLine;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;

@CommandLine.Command(name = "export")
public class ExportCmd extends AbstractCmd implements Callable<Integer> {
    @CommandLine.Parameters(defaultValue = "anypoint-export.json")
    private File file;
    @CommandLine.Option(names = {"-o"})
    private Set<String> orgs;
    @CommandLine.Option(names = {"-e"})
    private Set<String> envs;
    @CommandLine.Option(names = {"-da"})
    private boolean downloadApps;

    @Override
    public Integer call() throws Exception {
        ExportFilters exportFilters = new ExportFilters(orgs, envs);
        AnypointExportFile exportFile = new AnypointExportFile(exportFilters, downloadApps, getClient());
        exportFile.write(file);
        return 0;
    }
}
