/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.export.AnypointExportFile;
import com.aeontronix.anypointsdk.export.ExportFilters;
import com.fasterxml.jackson.databind.ObjectMapper;
import picocli.CommandLine;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;

@CommandLine.Command(name = "import")
public class ImportCmd extends AbstractCmd implements Callable<Integer> {
    @CommandLine.Parameters(defaultValue = "anypoint-export.json")
    private File file;
    @CommandLine.Option(names = {"-o"})
    private Set<String> orgs;
    @CommandLine.Option(names = {"-e"})
    private Set<String> envs;

    @Override
    public Integer call() throws Exception {
        ExportFilters exportFilters = new ExportFilters(orgs, envs);
        AnypointExportFile exportFile = new ObjectMapper().readValue(file, AnypointExportFile.class);
        exportFile.doImport(exportFilters, getClient());
        return 0;
    }
}
