/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.cli;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.auth.credentials.AnypointBearerTokenCredentials;
import com.aeontronix.anypointsdk.auth.credentials.AnypointCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import picocli.CommandLine;

import java.io.File;
import java.io.IOException;
import java.util.Map;

@CommandLine.Command(name = "anypoint", subcommands = {CH2Cmd.class, ExportCmd.class, ImportCmd.class, ConvertCmd.class})
public class MainCLI extends AbstractCmd {
    @CommandLine.Option(names = {"--bearer", "-b"})
    private String bearer;
    private AnypointClient client;

    @SuppressWarnings("rawtypes")
    @Override
    public AnypointClient getClient() {
        try {
            if (client == null) {
                if (bearer != null) {
                    return AnypointClient.builder().credentials(new AnypointBearerTokenCredentials(bearer)).build();
                } else {
                    final File cfgFile = new File(System.getProperty("user.home") + File.separator + ".enhanced-mule.config.json");
                    if (cfgFile.exists()) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        Map cfg = objectMapper.readValue(cfgFile, Map.class);
                        Map profiles = (Map) cfg.get("profiles");
                        if (profiles != null) {
                            Map profile = (Map) profiles.get(cfg.getOrDefault("active", "default"));
                            Object credentialsMap = profile.get("credentials");
                            if (credentialsMap != null) {
                                AnypointCredentials credentials = objectMapper.convertValue(credentialsMap, AnypointCredentials.class);
                                return AnypointClient.builder()
                                        .credentials(credentials).build();
                            }
                        }
                    }
                    throw new IllegalArgumentException("Credentials missing");
                }
            }
            return client;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        final MainCLI command = new MainCLI();
        final int stc = new CommandLine(command).execute(args);
        if (stc != 0) {
            System.exit(stc);
        }
    }
}
