/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.exchange;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

public class ExchangeClientApplicationData {
    @JsonProperty("redirectUri")
    private List<String> redirectUri;

    @JsonProperty("grantTypes")
    private List<String> grantTypes;

    @JsonProperty("clientId")
    private String clientId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("description")
    private String description;

    @JsonProperty("clientSecret")
    private String clientSecret;

    @JsonProperty("id")
    private Integer id;

    @JsonProperty("url")
    private String url;

    @JsonProperty("clientProvider")
    private ExchangeClientApplicationProvider clientProvider;

    @JsonProperty("masterOrganizationId")
    private String masterOrganizationId;

    public ExchangeClientApplicationData() {
    }

    public ExchangeClientApplicationData(String name, String description, String url) {
        this.name = name;
        this.description = description;
        this.url = url;
    }

    public ExchangeClientApplicationData(String name, String description, String url, List<String> redirectUri) {
        this(name, description, url);
        this.redirectUri = redirectUri;
    }

    public List<String> getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(List<String> redirectUri) {
        this.redirectUri = redirectUri;
    }

    public List<String> getGrantTypes() {
        return grantTypes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ExchangeClientApplicationProvider getClientProvider() {
        return clientProvider;
    }

    public void setClientProvider(ExchangeClientApplicationProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public String getMasterOrganizationId() {
        return masterOrganizationId;
    }

    public void setMasterOrganizationId(String masterOrganizationId) {
        this.masterOrganizationId = masterOrganizationId;
    }
}
