/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.export;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.AnypointException;
import com.aeontronix.anypointsdk.organization.Organization;
import com.aeontronix.restclient.RESTException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static org.slf4j.LoggerFactory.getLogger;

public class AnypointExportFile {
    private static final Logger logger = getLogger(AnypointExportFile.class);
    private List<OrgExport> orgs = new ArrayList<>();

    public AnypointExportFile() {
    }

    public AnypointExportFile(ExportFilters filters, boolean downloadApps, AnypointClient client) throws RESTException, IOException, AnypointException {
        for (Organization organization : client.findOrganizations()) {
            if (filters.processOrg(organization)) {
                getOrgs().add(new OrgExport(filters, downloadApps, client, organization));
            } else {
                logger.info("Skipping organization " + organization.getName());
            }
        }
    }

    public void doImport(ExportFilters filters, AnypointClient client) throws RESTException, IOException {
        for (OrgExport org : orgs) {
            org.doImport(filters, client);
        }
    }

    @JsonProperty
    public List<OrgExport> getOrgs() {
        return orgs;
    }

    public void setOrgs(List<OrgExport> orgs) {
        this.orgs = orgs;
    }

    public void write(File file) throws IOException {
        new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(file, this);
    }
}
