/*
 * Copyright (c) 2023. Aeontronix Inc
 */

package com.aeontronix.anypointsdk.export;

import com.aeontronix.anypointsdk.organization.Environment;
import com.aeontronix.anypointsdk.organization.Organization;

import java.util.Set;

public class ExportFilters {
    private Set<String> includeOrgs;
    private Set<String> includeEnvs;

    public ExportFilters() {
    }

    public ExportFilters(Set<String> includeOrgs, Set<String> includeEnvs) {
        this.includeOrgs = includeOrgs;
        this.includeEnvs = includeEnvs;
    }

    public Set<String> getIncludeOrgs() {
        return includeOrgs;
    }

    public void setIncludeOrgs(Set<String> includeOrgs) {
        this.includeOrgs = includeOrgs;
    }

    public Set<String> getIncludeEnvs() {
        return includeEnvs;
    }

    public void setIncludeEnvs(Set<String> includeEnvs) {
        this.includeEnvs = includeEnvs;
    }

    public boolean processOrg(Organization org) {
        return includeOrgs == null || includeOrgs.contains(org.getId()) || includeOrgs.contains(org.getName());
    }

    public boolean processEnv(Environment env) {
        return includeEnvs == null || includeEnvs.contains(env.getId()) || includeEnvs.contains(env.getName());
    }
}
